% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_strokes.R
\name{canvas_strokes}
\alias{canvas_strokes}
\title{Paint Strokes on a Canvas}
\usage{
canvas_strokes(colors, neighbors = 1, p = 0.01, iterations = 1, 
               width = 500, height = 500, side = FALSE)
}
\arguments{
\item{colors}{a character (vector) specifying the colors used for the strokes.}

\item{neighbors}{the number of neighbors a block considers when taking over a color. More neighbors fades the artwork.}

\item{p}{the probability of selecting a new color at each block. A higher probability adds more noise to the artwork.}

\item{iterations}{the number of iterations on the artwork. More iterations fade the artwork.}

\item{width}{the width of the artwork in pixels.}

\item{height}{the height of the artwork in pixels.}

\item{side}{whether to turn the artwork on its side.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function creates an artwork that resembles paints strokes. The algorithm is based on the simple idea that each next point on the grid has a chance to take over the color of an adjacent colored point but also has a change of generating a new color.
}
\examples{
\donttest{
set.seed(1)
canvas_strokes(colors = colorPalette('tuscany3'))
}

}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
