% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_mandelbrot.R
\name{canvas_mandelbrot}
\alias{canvas_mandelbrot}
\title{Paint the Mandelbrot Set on Canvas}
\usage{
canvas_mandelbrot(colors, n = 100, xmin = -1.7, xmax = -0.2, ymin = -0.2999, 
                   ymax = 0.8001, zoom = 1, width = 500, height = 500)
}
\arguments{
\item{colors}{a character (vector) specifying the colors used for the artwork.}

\item{n}{the number of iterations.}

\item{xmin}{the minimum x value.}

\item{xmax}{the maximum x value.}

\item{ymin}{the minimum y value.}

\item{ymax}{the maximum y value.}

\item{zoom}{the amount of zoom to apply.}

\item{width}{the width of the artwork in pixels.}

\item{height}{the height of the artwork in pixels.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws the Mandelbrot set on the canvas.
}
\examples{
\donttest{
set.seed(1)
canvas_mandelbrot(colors = colorPalette('dark1'), n = 100)
}

}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
