% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Make_Path.R
\docType{methods}
\name{Make_Path}
\alias{Make_Path}
\alias{Make_Path,aRchi-method}
\title{Make the path of a QSM in an aRchi object}
\usage{
Make_Path(aRchi)

\S4method{Make_Path}{aRchi}(aRchi)
}
\arguments{
\item{aRchi}{a file of class aRchi}
}
\value{
The aRchi object with the table of paths
}
\description{
Identify and record the paths of a QSM in an object of class aRchi. The path are needed for several tree metrics estimation of the aRchi package.
}
\details{
A path is a continuous succession of cylinders from a terminal segment (i.e a branch tip) to the trunk base. Thus, there is as many path as terminal segments in a QSM.

This function fill the slot Paths of an object of class aRchi with a data.table of the paths. This data.table contains the same variables as a classic QSM plus an ID_path column. This table is thus larger than the QSM table as each cylinder is repeated as many times as it appears in a path. For example, the first cylinder of the QSM (i.e the beginning of the trunk) is repeated N path times, with N path the number of path of the QSM.

Many function of the aRchi packages request a path table (check see also).
}
\examples{
\donttest{
# Read a QSM file
file=system.file("extdata","Tree_1_TreeQSM.txt",package = "aRchi")
QSM=read_QSM(file,model="treeQSM")
# Build an object of class aRchi
Tree1_aRchi<-build_aRchi(QSM=QSM)
Tree1_aRchi
# Make the path table
Tree1_aRchi<-Make_Path(Tree1_aRchi)
Tree1_aRchi
PathFraction(Tree1_aRchi)
}
}
\seealso{
\code{\link{BranchAngle}};\code{\link{Truncate_QSM}}; \code{\link{Clean_QSM}}; \code{\link{ForkRate}}; \code{\link{PathFraction}}
}
