% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_leaves.R
\name{add_leaves}
\alias{add_leaves}
\alias{add_leaves,aRchi-method}
\title{Generate foliage to a QSM or skeleton with segmented annual shoots.}
\usage{
add_leaves(
  aRchi,
  aArea = 73.027,
  bArea = 0.826,
  aNl = 2.563,
  bNl = 0.4402,
  aNin = 2.1337,
  bNin = 0.3818,
  elev = c(17, 45),
  elev_error = 5,
  az_err = 20,
  phyllo = "opposite_decussate",
  simple = T,
  petiole = 0.5
)

\S4method{add_leaves}{aRchi}(
  aRchi,
  aArea = 73.027,
  bArea = 0.826,
  aNl = 2.563,
  bNl = 0.4402,
  aNin = 2.1337,
  bNin = 0.3818,
  elev = c(17, 45),
  elev_error = 5,
  az_err = 20,
  phyllo = "opposite_decussate",
  simple = T,
  petiole = 0.5
)
}
\arguments{
\item{aRchi}{a file of class aRchi.}

\item{aArea}{numeric. Allometric coefficient (a) for leaf area per annual shoot.}

\item{bArea}{numeric. Allometric coefficient (b) for leaf area per annual shoot.}

\item{aNl}{numeric. Allometric coefficient (a) for the number of leaves per annual shoot.}

\item{bNl}{numeric. Allometric coefficient (b) for the number of leaves per annual shoot.}

\item{aNin}{numeric. Allometric coefficient (a) for the number of internodes per annual shoot.}

\item{bNin}{numeric. Allometric coefficient (b) for the number of internodes per annual shoot.}

\item{elev}{numeric. A single value or a vector of length 2 giving the leaves elevation angles.}

\item{elev_error}{numeric. A random error added to leaves elevation angle.}

\item{az_err}{numeric. A random error added to leaves azimuth.}

\item{phyllo}{character. The phyllotaxy used to insert the leaves along the annual shoot.
Accepted values: "alternate", "spiral", "opposite", "opposite_decussate".}

\item{simple}{logical. Bypass the allometry for the number of leaves per annual shoot
to insert the leaves on each internode.}

\item{petiole}{numeric. The petiole length given as a multiplier of the leaf length.}
}
\value{
The aRchi file now including the reconstructed foliage.
}
\description{
Generate foliage to a QSM or skeleton with segmented annual shoots.
}
\details{
Allometries for the leaf area, number of leaves and number of internodes are computed
         at the annual shoot level and are of the form \emph{X = a*AS_length^b}. The leaves elevation angle
         is constant if a single value is provided for \code{elev} or is linearly interpolated based
         of the leaf relative height within the tree crown if two values are provided.
}
\examples{
\donttest{
# import aRchi file
aRchi=system.file("extdata","Tree_2.aRchi",package = "aRchi")
aRchi = aRchi::read_aRchi(aRchi)

# smooth skeleton
aRchi = smooth_skeleton(aRchi)

# segment annual shoots
aRchi = aRchi::segment_annual_shoots(aRchi,tree_age = 13)

# add physiological ages
aRchi = aRchi::add_physiological_ages(aRchi)

# add leaves
aRchi = aRchi::add_leaves(aRchi)

plot(aRchi,leaves=TRUE,bg="white",color="chocolate4")
}
}
\references{
Lecigne, B., Delagrange, S., Lauri, P. É., & Messier, C. (2022). Trimming influences tree light interception
            and space exploration: contrasted responses of two cultivars of Fraxinus pennsylvanica at various scales of
            their architecture. Trees, 1-17. https://doi.org/10.1007/s00468-022-02273-5
}
