% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Compute_Mf.R
\docType{methods}
\name{Compute_Mf}
\alias{Compute_Mf}
\alias{Compute_Mf,aRchi-method}
\title{Compute Moment of force}
\usage{
Compute_Mf(aRchi, WoodDensity)

\S4method{Compute_Mf}{aRchi}(aRchi, WoodDensity = NULL)
}
\arguments{
\item{aRchi}{an object of class aRchi with at least the QSM and the paths table.}

\item{WoodDensity}{a numeric or a data.table. A single wood density value for the whole tree or one value per cylinder in kg/m3. If wood density is given for each cylinder a data.table with two column (i.e cyl_ID and WoodDensity) must be given.}
}
\value{
The aRchi file with the QSM slot having three new columns: the biomass upstream the cylinder \code{sub_tree_biomass}, the moment of gravity force \code{Mf} and the moment of gravity force relative to cylinder radius \code{Mf_r}.
}
\description{
Compute the moment of gravity force Mf and the moment of gravity force relative to cylinder radius Mf_r from an object of class aRchi.
}
\details{
The moment of gravity force (i.e \code{Mf}) is calculated at each cylinder position. \code{Mf} can be seen as a proxy of the mechanical loading history due to gravity at a given position of a tree.
This quantity is defined by the following the equation: Mf=R*FALSE where R is the lever arm, which is the norm of the horizontal vector between the position where \code{Mf} is measured (i.e a cylinder) and the position where the force is applied (i.e., the center of mass, G, of the whole structure upstream a cylinder: a subtree).

The mass of the cylinders are needed to calculate the center of mass and are estimated using their volume and the wood density provided in argument \code{WoodDensity}. Finally, FALSE is the weight of the subtree: FALSE=g*M	with g the standard acceleration due to gravity (9.81 m.s-²).

The moment of gravity force relative (i.e \code{Mf_r}) to cylinder radius r is also computed following the formula: Mf_r = Mf/r^3
}
\examples{
\donttest{
# Read an aRchi file with a QSM and paths tables.
file=system.file("extdata","Tree_1_aRchi.aRchi",package = "aRchi")
Tree1_aRchi=read_aRchi(file)

# Compute the moment of force for each cylinder
Tree1_aRchi=Compute_Mf(Tree1_aRchi,WoodDensity=550)

# show the QSM data.table with the three new columns sub_tree_biomass, MF and Mf_r)
get_QSM(Tree1_aRchi)
}

}
