% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aMNLFA_final.R
\name{aMNLFA.final}
\alias{aMNLFA.final}
\title{aMNLFA final model fitting function}
\usage{
aMNLFA.final(input.object)
}
\arguments{
\item{input.object}{The aMNLFA object (created using the aMNLFA.object function) which provides instructions for the function.}
}
\description{
This function generates the final aMNLFA model on which scores will be based. Can only be run after a model containing all impact and DIF effects -- i.e., after the aMNLFA.simultaneous function.
}
\examples{
 wd <- tempdir()
 first<-paste0(system.file(package='aMNLFA'),"/examplefiles")
 the.list <- list.files(first,full.names=TRUE)
 file.copy(the.list,wd,overwrite=TRUE)
 ob <- aMNLFA::aMNLFA.object(dir = wd, 
 mrdata = xstudy, 
 indicators = paste0("BIN_", 1:12),
 catindicators = paste0("BIN_", 1:12), 
 meanimpact = c("AGE", "GENDER", "STUDY"), 
 varimpact = c("AGE", "GENDER", "STUDY"), 
 measinvar = c("AGE", "GENDER", "STUDY"),
 factors = c("GENDER", "STUDY"),
 ID = "ID",
 thresholds = FALSE)
 
 aMNLFA.final(ob)
}
\keyword{MNLFA}
