% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FishPar.R
\name{FishPar}
\alias{FishPar}
\title{Calculate Length-Based Indicators for Fish Stock Assessment
#'@importFrom graphics abline axis barplot box boxplot hist legend lines par rect segments text}
\usage{
FishPar(data, resample, progress)
}
\arguments{
\item{data}{A data frame containing two columns: Length and Frequency.}

\item{resample}{An integer indicating the number of bootstrap resamples.}

\item{progress}{A logical value indicating whether to display progress.}
}
\value{
A list containing estimated length parameters, Froese indicators, and other relevant metrics.
}
\description{
This function calculates various length-based indicators for fish stock assessment
using length frequency data and bootstrap resampling.
}
\examples{
data <- data.frame(Length = c(10, 20, 30, 40, 50), Frequency = c(5, 10, 15, 20, 25))
FishPar(lenfreq01, 100, progress = FALSE)
utils::data("lenfreq01", package = "aLBI")
utils::data("lenfreq02", package = "aLBI")
}
