% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVM.R
\name{SVM}
\alias{SVM}
\title{Find a SVM curve to separate positive and negative controls.}
\usage{
SVM(ECdataList)
}
\arguments{
\item{ECdataList}{data list of output EventCoverage, names of list shoule be 'EC_N_D', 'EC_P_D', 'EC_N_I', 'EC_P_I' and 'ZseqList'}
}
\value{
A list of data.frame, including 'cutOffD' and 'cutOffI'.cutOffD and cutOffI are the deduced SVM.
}
\description{
Radical kernel SVM is constructed to maximally separate positive controls from negative controls in the prior defined Z range using e1071 packages of R, and therefore, the SVM curve is generated.
}
\examples{
data(countMat)
data(negGene)
data(posGene)
ZscoreVal <- Zscore(countMat,negGene)
ECdataList <- EventCoverage(ZscoreVal,negGene,posGene,binNum=10,combine=TRUE)
\donttest{SVM(ECdataList)}

}
\author{
Yajing Hao, Shuyang Zhang, Junhui Li, Guofeng Zhao, Xiang-Dong Fu
}
\keyword{machine}
\keyword{support}
\keyword{vector}
