% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Expand_Temperatures.R
\name{Expand_Temperatures}
\alias{Expand_Temperatures}
\title{Adjusting the temperature schedule}
\usage{
Expand_Temperatures(
  temperatures,
  loglike,
  rho,
  bisec_tol = .Machine$double.eps^0.25
)
}
\arguments{
\item{temperatures}{A vector of length \eqn{T} temperatures for the power posterior temperatures.}

\item{loglike}{An \eqn{N} by \eqn{T} matrix of log likelihood values corresponding to the samples.}

\item{rho}{The tolerance for the new temperatures. Temperatures are selected so that the conditional effective sample size (CESS) at each temperature is \eqn{\rho*N} where \eqn{N} is the population size.}

\item{bisec_tol}{The tolerance for the bisection method used in selecting temperatures. The default is \code{.Machine$double.eps^0.25}}
}
\value{
A list is returned, containing the following components:
\itemize{
\item \code{temperatures_all}: The new set of temperatures of length \eqn{tau}.
\item \code{relevant_samples}: A vector of length \eqn{tau} containing indices to show which particle sets the new temperatures are based on.
\item \code{logw}: An \eqn{N} by \eqn{tau} matrix of log normalised weights of the particles
}
}
\description{
This function is used to adjust the temperature schedule so that it is more (or less) strict than the original.
}
\references{
South, L. F., Oates, C. J., Mira, A., & Drovandi, C. (2019). Regularised zero variance control variates for high-dimensional variance reduction. \url{https://arxiv.org/abs/1811.05073}
}
\seealso{
See \code{\link{evidence}} for functions to estimate the evidence, \code{\link{VDP}} for an example and \link{ZVCV} for more package details.
}
\author{
Leah F. South
}
