% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_est.R
\name{get_est}
\alias{get_est}
\title{Get Parameter Estimates from Stan Model Fit}
\usage{
get_est(distri, stan_fit)
}
\arguments{
\item{distri}{Character string specifying the distribution. Options
are "poi" or "nb".}

\item{stan_fit}{A \code{stanfit} object returned by \code{get_stanfit}.}
}
\value{
A summary of the parameter estimates.
}
\description{
Extracts parameter estimates from a Stan model fit, including mean, median,
standard deviation, and HPD intervals.
}
\examples{
\donttest{
  # Generate toy data
  y_data <- data_simu(n = 60, alpha = 0.5, rho = 0.3, theta = c(5),
                      mod_type = "zi", distri = "poi")

  # Fit a small Stan model (may take > 5s on first compile)
  stan_fit <- get_stanfit(mod_type = "zi", distri = "poi", y = y_data)

  # Get parameter estimates from the Stan model fit
  get_est(distri = "poi", stan_fit = stan_fit)
}

}
