% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_observations.R
\name{combine_observations}
\alias{combine_observations}
\title{Combine parsed observations into a single parsed object}
\usage{
combine_observations(...)
}
\arguments{
\item{...}{Parsed datasets to combine (i.e., outputs from 
\code{Xcertainty::parsed_observations})}
}
\value{
outputs a list with four elements: 
\describe{
 \item{pixel_counts}{a tibble containing the measurements in pixels 
 linked with Subject, Measurement description, Image, and the Timepoint}
 \item{training_objects}{a tibble containing the Subject, Measurement, Length, 
 and Timepoint. NULL if no training objects were included}
 \item{prediction_objects}{a tibble containing the Subject, Measurement, and 
 Timepoint. NULL if no prediction data included}
 \item{image_info}{a tibble containing the Image, Barometer, Laser, FocalLength,
 ImageWidth, SensorWidth, and UAS}
 }
}
\description{
Combine parsed observations, such as calibration and observation (whale) data into a single parsed object. 
This combined, single parsed object can then be used as the data input for one of the samplers.
}
\examples{
# load example wide-format data
data("calibration")
data("whales")

# parse calibration study
calibration_data = parse_observations(
  x = calibration, 
  subject_col = 'CO.ID',
  meas_col = 'Lpix', 
  tlen_col = 'CO.L', 
  image_col = 'image', 
  barometer_col = 'Baro_Alt',
  laser_col = 'Laser_Alt', 
  flen_col = 'Focal_Length', 
  iwidth_col = 'Iw', 
  swidth_col = 'Sw',
  uas_col = 'uas'
)

# parse field study
whale_data = parse_observations(
  x = whales, 
  subject_col = 'whale_ID',
  meas_col = 'TL.pix', 
  image_col = 'Image', 
  barometer_col = 'AltitudeBarometer',
  laser_col = 'AltitudeLaser', 
  flen_col = 'FocalLength', 
  iwidth_col = 'ImageWidth', 
  swidth_col = 'SensorWidth', 
  uas_col = 'UAS',
  timepoint_col = 'year'
)

# combine parsed calibration and observation (whale) data
combined_data = combine_observations(calibration_data, whale_data)
}
