% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/ProxyClass.R
\docType{class}
\name{ProxyClassObject-class}
\alias{ProxyClassObject}
\alias{ProxyClassObject-class}
\title{A Class for Objects that are Proxies for Specific Server Class Objects}
\description{
This class is extended by all specific proxy classes for a particular language.
If a proxy object is returned from the server language whose server class matches a
defined proxy class, then an object from that class is generated.
}
\section{Fields}{

\describe{
\item{\code{.proxyObject}}{the actual proxy reference}

\item{\code{.proxyClass}}{the description of the server language class (name, module, langauge)}

\item{\code{.ev}}{the evaluator that produced this proxy object.}
}}
\section{Methods}{

\describe{
\item{\code{proxyName()}}{the character string under which the server language object is assigned.
Useful to examine the object in a shell for the server language.}

\item{\code{size()}}{returns the server-language size of the object, possibly NA}
}}
\references{
Chambers, John M. (2016)
\emph{Extending R},
Chapman & Hall/CRC.
( Chapter 12, discussing this package, is included in the package: \url{../doc/Chapter_XR.pdf}.)
}

