/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.presentationml.x2006.main.CTSlideMaster;
import org.openxmlformats.schemas.presentationml.x2006.main.SldMasterDocument;

public class XSLFSlideMaster
extends XSLFSheet {
    private CTSlideMaster _slide;
    private Map<String, XSLFSlideLayout> _layouts;
    private XSLFTheme _theme;

    XSLFSlideMaster() {
        this._slide = CTSlideMaster.Factory.newInstance();
    }

    protected XSLFSlideMaster(PackagePart part, PackageRelationship rel) throws IOException, XmlException {
        super(part, rel);
        SldMasterDocument doc = SldMasterDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream());
        this._slide = doc.getSldMaster();
    }

    public CTSlideMaster getXmlObject() {
        return this._slide;
    }

    protected String getRootElementName() {
        return "sldMaster";
    }

    public XSLFSlideLayout getLayout(String name) {
        if (this._layouts == null) {
            this._layouts = new HashMap<String, XSLFSlideLayout>();
            for (POIXMLDocumentPart p : this.getRelations()) {
                if (!(p instanceof XSLFSlideLayout)) continue;
                XSLFSlideLayout layout = (XSLFSlideLayout)p;
                this._layouts.put(layout.getName().toLowerCase(), layout);
            }
        }
        return this._layouts.get(name);
    }

    public XSLFTheme getTheme() {
        if (this._theme == null) {
            for (POIXMLDocumentPart p : this.getRelations()) {
                if (!(p instanceof XSLFTheme)) continue;
                this._theme = (XSLFTheme)p;
                break;
            }
        }
        return this._theme;
    }
}

