% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xEnrichMatrix.r
\name{xEnrichMatrix}
\alias{xEnrichMatrix}
\title{Function to compare enrichment results using matrix plots}
\usage{
xEnrichMatrix(list_eTerm, method = c("ggplot2", "circle", "square",
"color", "pie"), displayBy = c("zscore", "fc", "adjp", "pvalue"),
FDR.cutoff = 0.05, wrap.width = NULL, sharings = NULL,
reorder = c("row", "none", "col", "both"), colormap = "jet",
ncolors = 20, zlim = NULL, slim = NULL,
legend.direction = c("horizontal", "vertical"), title = NULL,
flip = FALSE, y.rotate = 45, shape = 19, font.family = "sans",
...)
}
\arguments{
\item{list_eTerm}{a list of "eTerm" objects, or a data frame (with at
least 3 columns "group", "name" and "adjp")}

\item{method}{which method will be used for plotting. It can be
"circle" (by default), "square", "color" and "pie"}

\item{displayBy}{which statistics will be used for comparison. It can
be "fc" for enrichment fold change (by default), "adjp" for adjusted p
value (or FDR), "pvalue" for p value, "zscore" for enrichment z-score}

\item{FDR.cutoff}{FDR cutoff used to declare the significant terms. By
default, it is set to 0.05}

\item{wrap.width}{a positive integer specifying wrap width of name}

\item{sharings}{a numeric vector specifying whether only shared terms
will be displayed. For example, when comparing three groups of
enrichment results, it can be set into c(2,3) to display only shared
terms by any two or all three. By default, it is NULL meaning no such
restriction}

\item{reorder}{how to reorder rows and columns. It can be "none" for no
reordering, "row" for reordering rows according to number of sharings
(by default), "col" for reordering columns, and "both" for reordering
rows and columns}

\item{colormap}{short name for the colormap. It can be one of "jet"
(jet colormap), "bwr" (blue-white-red colormap), "gbr" (green-black-red
colormap), "wyr" (white-yellow-red colormap), "br" (black-red
colormap), "yr" (yellow-red colormap), "wb" (white-black colormap), and
"rainbow" (rainbow colormap, that is,
red-yellow-green-cyan-blue-magenta). Alternatively, any
hyphen-separated HTML color names, e.g. "blue-black-yellow",
"royalblue-white-sandybrown", "darkgreen-white-darkviolet". A list of
standard color names can be found in
\url{http://html-color-codes.info/color-names}}

\item{ncolors}{the number of colors specified over the colormap}

\item{zlim}{the minimum and maximum z values for which colors should be
plotted, defaulting to the range of the finite values of displayed
matrix}

\item{slim}{the minimum and maximum displaying values for which sizes
should be plotted}

\item{legend.direction}{the legend guide direction. It can be
"horizontal" (useful for many groups with lengthy labelling),
"vertical"}

\item{title}{the title of the plot. By default, it is NULL}

\item{flip}{logical to indicate whether to flip the coordiate. By
default, it sets to false}

\item{y.rotate}{the angle to rotate the y tick labelings. By default,
it is 45}

\item{shape}{the number specifying the shape. By default, it is 19}

\item{font.family}{the font family for texts}

\item{...}{additional graphic parameters for corrplot::corrplot}
}
\value{
If the method is 'ggplot2', it returns a ggplot object. Otherwise, it
is a data frame
}
\description{
\code{xEnrichMatrix} is supposed to compare enrichment results using
matrix plots.
}
\note{
none
}
\examples{
\dontrun{
# Load the XGR package and specify the location of built-in data
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata/"
xEnrichMatrix(list_eTerm, method="circle", displayBy="adjp",
FDR.cutoff=0.05, wrap.width=50, sharings=NULL, reorder="row",
colormap="black-yellow-red", ncolors=16, zlim=c(0,8), cl.pos="b",
cl.ratio=0.1, cl.align.text="c", tl.col="black", tl.cex=0.7, tl.srt=90,
title=paste0(ontology,": log10(FDR)"))
xEnrichMatrix(list_eTerm, method="pie", displayBy="adjp",
FDR.cutoff=0.05, wrap.width=50, sharings=NULL, reorder="row",
colormap="grey-grey", ncolors=1, zlim=c(0,8), cl.pos="n", cl.ratio=0.1,
cl.align.text="c", tl.col="black", tl.cex=0.7, tl.srt=90,
title=paste0(ontology,": log10(FDR)"))
gp <- xEnrichMatrix(list_eTerm, method="ggplot2", displayBy="zscore",
FDR.cutoff=0.05, wrap.width=40, sharings=NULL, reorder="row",
colormap="yellow-red", flip=T, y.rotate=45, font.family=font.family)
}
}
\seealso{
\code{\link{xEnricherGenes}}, \code{\link{xEnricherSNPs}},
\code{\link{xEnrichViewer}}
}
