% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xDefineHIC.r
\name{xDefineHIC}
\alias{xDefineHIC}
\title{Function to extract promoter capture HiC-gene pairs given a list of SNPs}
\usage{
xDefineHIC(data = NULL, entity = c("SNP", "chr:start-end",
"data.frame", "bed", "GRanges"), include.HiC = c(NA, "Monocytes",
"Macrophages_M0", "Macrophages_M1", "Macrophages_M2", "Neutrophils",
"Megakaryocytes", "Endothelial_precursors", "Erythroblasts",
"Fetal_thymus", "Naive_CD4_T_cells", "Total_CD4_T_cells",
"Activated_total_CD4_T_cells", "Nonactivated_total_CD4_T_cells",
"Naive_CD8_T_cells", "Total_CD8_T_cells", "Naive_B_cells",
"Total_B_cells", "PE.Monocytes", "PE.Macrophages_M0",
"PE.Macrophages_M1", "PE.Macrophages_M2", "PE.Neutrophils",
"PE.Megakaryocytes", "PE.Erythroblasts", "PE.Naive_CD4_T_cells",
"PE.Naive_CD8_T_cells", "Combined", "Combined_PE"),
GR.SNP = c("dbSNP_GWAS", "dbSNP_Common", "dbSNP_Single"),
verbose = TRUE,
RData.location = "http://galahad.well.ox.ac.uk/bigdata")
}
\arguments{
\item{data}{NULL or an input vector containing SNPs. If NULL, all SNPs
will be considered. If a input vector containing SNPs, SNPs should be
provided as dbSNP ID (ie starting with rs) or in the format of
'chrN:xxx', where N is either 1-22 or X, xxx is number; for example,
'chr16:28525386'. Alternatively, it can be other formats/entities (see
the next parameter 'entity')}

\item{entity}{the data entity. By default, it is "SNP". For general
use, it can also be one of "chr:start-end", "data.frame", "bed" or
"GRanges"}

\item{include.HiC}{genes linked to input SNPs are also included. By
default, it is 'NA' to disable this option. Otherwise, those genes
linked to SNPs will be included according to Promoter Capture HiC
(PCHiC) datasets. Pre-built HiC datasets are detailed in the section
'Note'}

\item{GR.SNP}{the genomic regions of SNPs. By default, it is
'dbSNP_GWAS', that is, SNPs from dbSNP (version 146) restricted to GWAS
SNPs and their LD SNPs (hg19). It can be 'dbSNP_Common', that is,
Common SNPs from dbSNP (version 146) plus GWAS SNPs and their LD SNPs
(hg19). Alternatively, the user can specify the customised input. To do
so, first save your RData file (containing an GR object) into your
local computer, and make sure the GR object content names refer to
dbSNP IDs. Then, tell "GR.SNP" with your RData file name (with or
without extension), plus specify your file RData path in
"RData.location". Note: you can also load your customised GR object
directly}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
If input data is NULL, a data frame with following columns:
\itemize{
\item{\code{from}: baited genomic regions (baits)}
\item{\code{to}: preyed (other end) genomic regions of interactions
(preys)}
\item{\code{score}: CHiCAGO scores quantifying the strength of physical
interactions between harbors and partners}
}
If input data is not NULL, a list with two components: "df" and "ig".
"df" is a data frame with following columns:
\itemize{
\item{\code{from}: 'from/bait' genomic regions}
\item{\code{to}: 'to/prey' genomic regions}
\item{\code{score}: CHiCAGO scores quantifying the strength of physical
interactions between baits and preys}
\item{\code{from_genes}: genes associated with 'from/bait' genomic
regions}
\item{\code{to_genes}: genes associated with 'to/prey' genomic regions}
\item{\code{SNP}: input SNPs (in query)}
\item{\code{SNP_end}: specify which end SNPs in query fall into (either
'bait/from' or 'prey/to')}
\item{\code{SNP_harbor}: genomic regions harbors the SNPs in query}
\item{\code{Context}: the context in which PCHiC data was generated}
}
"ig" is an object of both classes "igraph" and "PCHiC", a direct graph
with nodes for genomic regions and edges for CHiCAGO scores between
them. Also added node attribute is 1) 'target' storing genes assocated
and 2) 'SNP' for input SNPs (if the node harboring input SNPs). If
several cell types are queried, "ig" is actually a list of
"igraph"/"PCHiC" objects.
}
\description{
\code{xDefineHIC} is supposed to extract HiC-gene pairs given a list of
SNPs.
}
\note{
Pre-built HiC datasets are described below according to the data
sources.\cr
1. Promoter Capture HiC datasets in 17 primary blood cell types.
Sourced from Cell 2016, 167(5):1369-1384.e19
\itemize{
\item{\code{Monocytes}: physical interactions (CHiCAGO score >=5) of
promoters (baits) with the other end (preys) in Monocytes.}
\item{\code{Macrophages_M0}: promoter interactomes in Macrophages M0.}
\item{\code{Macrophages_M1}: promoter interactomes in Macrophages M1.}
\item{\code{Macrophages_M2}: promoter interactomes in Macrophages M2.}
\item{\code{Neutrophils}: promoter interactomes in Neutrophils.}
\item{\code{Megakaryocytes}: promoter interactomes in Megakaryocytes.}
\item{\code{Endothelial_precursors}: promoter interactomes in
Endothelial precursors.}
\item{\code{Erythroblasts}: promoter interactomes in Erythroblasts.}
\item{\code{Fetal_thymus}: promoter interactomes in Fetal thymus.}
\item{\code{Naive_CD4_T_cells}: promoter interactomes in Naive CD4+ T
cells.}
\item{\code{Total_CD4_T_cells}: promoter interactomes in Total CD4+ T
cells.}
\item{\code{Activated_total_CD4_T_cells}: promoter interactomes in
Activated total CD4+ T cells.}
\item{\code{Nonactivated_total_CD4_T_cells}: promoter interactomes in
Nonactivated total CD4+ T cells.}
\item{\code{Naive_CD8_T_cells}: promoter interactomes in Naive CD8+ T
cells.}
\item{\code{Total_CD8_T_cells}: promoter interactomes in Total CD8+ T
cells.}
\item{\code{Naive_B_cells}: promoter interactomes in Naive B cells.}
\item{\code{Total_B_cells}: promoter interactomes in Total B cells.}
\item{\code{Combined}: promoter interactomes combined above; with score
for the number of significant cell types plus scaled average.}
}
2. Promoter Capture HiC datasets (involving active promoters and
enhancers) in 9 primary blood cell types. Sourced from Cell 2016,
167(5):1369-1384.e19
\itemize{
\item{\code{PE.Monocytes}: physical interactions (CHiCAGO score >=5) of
promoters (baits) with the other end (enhancers as preys) in
Monocytes.}
\item{\code{PE.Macrophages_M0}: promoter-enhancer interactomes in
Macrophages M0.}
\item{\code{PE.Macrophages_M1}: promoter-enhancer interactomes in
Macrophages M1.}
\item{\code{PE.Macrophages_M2}: promoter-enhancer interactomes in
Macrophages M2.}
\item{\code{PE.Neutrophils}: promoter-enhancer interactomes in
Neutrophils.}
\item{\code{PE.Megakaryocytes}: promoter-enhancer interactomes in
Megakaryocytes.}
\item{\code{PE.Erythroblasts}: promoter-enhancer interactomes in
Erythroblasts.}
\item{\code{PE.Naive_CD4_T_cells}: promoter-enhancer interactomes in
Naive CD4+ T cells.}
\item{\code{PE.Naive_CD8_T_cells}: promoter-enhancer interactomes in
Naive CD8+ T cells.}
\item{\code{Combined_PE}: promoter interactomes combined above; with
score for the number of significant cell types plus scaled average.}
}
}
\examples{
\dontrun{
# Load the library
library(XGR)
}

RData.location <- "http://galahad.well.ox.ac.uk/bigdata"
\dontrun{
# a) provide the SNPs with the significance info
data(ImmunoBase)
data <- names(ImmunoBase$AS$variants)

# b) extract HiC-gene pairs given a list of AS SNPs
PCHiC <- xDefineHIC(data, include.HiC="Monocytes", GR.SNP="dbSNP_GWAS",
RData.location=RData.location)
head(PCHiC$df)

# c) visualise the interaction (a directed graph: bait->prey)
g <- PCHiC$ig
## a node with SNPs colored in 'skyblue' and the one without SNPs in 'pink'
## the width in an edge is proportional to the interaction strength
xPCHiCplot(g, vertex.label.cex=0.5)
xPCHiCplot(g, glayout=layout_in_circle, vertex.label.cex=0.5)
}
}
\seealso{
\code{\link{xRDataLoader}}
}
