% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xRPS.r
\name{xRPS}
\alias{xRPS}
\title{Function to calculate regulatory potential scores for genomic regions using genomic annotations}
\usage{
xRPS(data, format = c("data.frame", "bed", "chr:start-end", "GRanges"),
build.conversion = c(NA, "hg38.to.hg19", "hg18.to.hg19"),
GR.annotation = c("FANTOM5_Enhancer_Cell", "FANTOM5_Enhancer_Tissue",
"FANTOM5_CAT_Cell", "FANTOM5_CAT_Tissue", "GWAScatalog_alltraits",
"ENCODE_DNaseI_ClusteredV3", "ENCODE_TFBS_ClusteredV3",
"EpigenomeAtlas_15Segments", "RecombinationRate", "phastCons100way",
"phyloP100way"), verbose = T,
RData.location = "http://galahad.well.ox.ac.uk/bigdata")
}
\arguments{
\item{data}{input genomic regions (GR). If formatted as "chr:start-end"
(see the next parameter 'format' below), GR should be provided as a
vector in the format of 'chrN:start-end', where N is either 1-22 or X,
start (or end) is genomic positional number; for example, 'chr1:13-20'.
If formatted as a 'data.frame', the first three columns correspond to
the chromosome (1st column), the starting chromosome position (2nd
column), and the ending chromosome position (3rd column). If the format
is indicated as 'bed' (browser extensible data), the same as
'data.frame' format but the position is 0-based offset from chromomose
position. If the genomic regions provided are not ranged but only the
single position, the ending chromosome position (3rd column) is allowed
not to be provided. The data could also be an object of 'GRanges' (in
this case, formatted as 'GRanges')}

\item{format}{the format of the input data. It can be one of
"data.frame", "chr:start-end", "bed" or "GRanges"}

\item{build.conversion}{the conversion from one genome build to
another. The conversions supported are "hg38.to.hg19" and
"hg18.to.hg19". By default it is NA (no need to do so)}

\item{GR.annotation}{the genomic regions of annotation data. Pre-built
genomic annotation data are detailed in the section 'Note'}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to false for no display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
a GenomicRanges object appended a metacolumn 'RPS'
}
\description{
\code{xRPS} is supposed to calculate regulatory potential scores for
genomic regions using genomic annotations.
}
\note{
The genomic annotation data are described below according to the data
sources and data types.\cr
1. FANTOM5 expressed enhancer atlas
\itemize{
\item{\code{FANTOM5_Enhancer_Cell}: a list (71 cell types) of
GenomicRanges objects; each is an GR object containing enhancers
specifically expressed in a cell type.}
\item{\code{FANTOM5_Enhancer_Tissue}: a list (41 tissues) of
GenomicRanges objects; each is an GR object containing enhancers
specifically expressed in a tissue.}
}
2. FANTOM5 sample-ontology-enriched CAT genes
\itemize{
\item{\code{FANTOM5_CAT_Cell}: a list (173 cell types) of GenomicRanges
objects; each is an GR object containing CAT genes specifically
expressed in a cell type.}
\item{\code{FANTOM5_CAT_Tissue}: a list (174 tissues) of GenomicRanges
objects; each is an GR object containing CAT genes specifically
expressed in a tissue.}
}
3. GWAS Catalog trait-associated SNPs
\itemize{
\item{\code{GWAScatalog_alltraits}: a list (390 traits grouped by EFO)
of GenomicRanges objects; each is an GR object containing
trait-associated SNPs.}
}
4. ENCODE DNaseI Hypersensitivity site data
\itemize{
\item{\code{ENCODE_DNaseI_ClusteredV3}: a GR object containing
clustered peaks, along with a meta-column 'num_cells' telling how many
cell types associated with a clustered peak.}
}
5. ENCODE Transcription Factor ChIP-seq data
\itemize{
\item{\code{ENCODE_TFBS_ClusteredV3}: a list (161 transcription
factors) of GenomicRanges objects; each is an GR object containing
clustered peaks per transcription factor, along with a meta-column
'cells' telling cell types associated with a clustered peak.}
}
6. Roadmap Epigenomics Core 15-state Genome Segmentation data for 127
cell types
\itemize{
\item{\code{EpigenomeAtlas_15Segments}: a list (127 cell types) of a
list (15 categories of segments) of GenomicRanges objects; each is an
GR object containing segments per category in the reference epigenome.}
}
7. Genomic scores
\itemize{
\item{\code{RecombinationRate}: a GR object containing a meta-column
for recombination rates.}
\item{\code{phastCons100way}: a GR object containing a meta-column for
phastCons100way.}
\item{\code{phyloP100way}: a GR object containing a meta-column for
phyloP100way.}
}
}
\examples{
\dontrun{
# Load the XGR package and specify the location of built-in data
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata"

# transcribed lncRNAs
FANTOM5_CAT <- xRDataLoader('FANTOM5_CAT',
RData.location=RData.location)
GR_lncRNA <- FANTOM5_CAT[grepl('lncRNA',FANTOM5_CAT$Class)]
names(GR_lncRNA) <- NULL
data <- GR_lncRNA
# RPS calculation
dGR <- xRPS(data, format="GRanges",
GR.annotation=c("FANTOM5_CAT_Cell","FANTOM5_CAT_Tissue"),
RData.location=RData.location)
}
}
\seealso{
\code{\link{xEnrichViewer}}
}
