% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xPrioritiserManhattan.r
\name{xPrioritiserManhattan}
\alias{xPrioritiserManhattan}
\title{Function to visualise prioritised genes using manhattan plot}
\usage{
xPrioritiserManhattan(pNode, color = c("darkred", "darkgreen"), cex =
0.5,
highlight.top = 20, highlight.col = "deepskyblue",
highlight.label.size = 2, highlight.label.offset = 0.02,
highlight.label.col = "darkblue", verbose = T,
RData.location =
"https://github.com/hfang-bristol/RDataCentre/blob/master/XGR/1.0.0")
}
\arguments{
\item{pNode}{an object of class "pNode"}

\item{color}{a character vector for point colors to alternate}

\item{cex}{a numeric value for point size}

\item{highlight.top}{the number of the top targets to be highlighted}

\item{highlight.col}{the highlight colors}

\item{highlight.label.size}{the highlight label size}

\item{highlight.label.offset}{the highlight label offset}

\item{highlight.label.col}{the highlight label color}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to false for no display}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
an object of class "ggplot"
}
\description{
\code{xPrioritiserManhattan} is supposed to visualise prioritised genes
using manhattan plot. Genes with the top priority are highlighed. It
returns an object of class "ggplot".
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
library(igraph)
library(dnet)
library(ggbio)

# a) provide the SNPs with the significance info
## get lead SNPs reported in AS GWAS and their significance info (p-values)
AS <- read.delim(file.path(path.package("XGR"),"AS.txt"),
stringsAsFactors=FALSE)

# b) perform priority analysis
pNode <- xPrioritiserSNPs(data=AS,
network="PCommonsUN_medium",restart=0.7)

# c) manhattan plot
mp <- xPrioritiserManhattan(pNode, highlight.top=10)
#pdf(file="Gene_manhattan.pdf", height=6, width=12, compress=TRUE)
print(mp)
#dev.off()
}
}
\seealso{
\code{\link{xRDataLoader}}, \code{\link{xPrioritiser}},
\code{\link{xPrioritiserSNPs}}, \code{\link{xPrioritiserGenes}},
\code{\link{xPrioritiserPathways}}
}

