\name{wilcox.split}
\alias{wilcox.split}

\title{Wilcoxon rank sum statistic in cross-validation (CV) and Monte-Carlo cross-validation (MCCV)}
\usage{
wilcox.split(x,y,split,algo="new")
}
\arguments{
  \item{x}{a numeric vector of length n giving the expression levels of a gene for the n arrays.}
  \item{y}{a vector of length n giving the class membership for the n arrays. \code{y} can be
either a factor or a numeric and must be coded as 0,1.}
\item{split}{A \code{niter} x \code{ntest} matrix giving the indices of the \code{ntest} observations included
in each of the \code{niter} test sets, as generated by the functions \code{\link{generate.split}} or \code{\link{generate.cv}}. The i-th row of \code{split} gives the indices of the observations included in the test data set for the i-th iteration.}

  \item{algo}{either \code{"new"} or \code{"naive"}. If \code{algo="new"}, the new fast method
described in Boulesteix (2007) is used to compute the Wilcoxon rank statistic. If \code{algo="naive"}, the
Wilcoxon rank sum statistics are obtained by running the function \code{wilcox.test} \code{niter} times.}
}
\description{
The function \code{wilcox.split}  computes the Wilcoxon rank sum statistic for all \code{niter} CV or MCCV iterations defined by the matrix \code{split}.
  
}


\details{The Wilcoxon rank sum statistic is defined as the sum of the X-ranks of
the observations with \code{y=0}. The Wilcoxon rank sum test is equivalent to the
Mann-Whitney test. It is implemented in the function \code{wilcox.test}.

In the context of cross-validation (CV) or Monte-Carlo cross-validation (MCCV), \code{wilcox.selection.split} computes the
Wilcoxon rank sum statistic for each iteration. At each iteration, a subset
of the \code{n} observations is excluded from the data set and considered as test data set. 
The indices of the observations considered as test set for each of the \code{niter} iterations
are given in the \code{niter} x \code{ntest} matrix \code{split}.
 
}

\value{
  A list with the following components:
  \item{wilcox.split}{a numeric vector of length \code{niter} whose i-th component gives the Wilcoxon rank sum statistic obtained in the i-th iteration.}
  
  
}

\references{
 
  A. L. Boulesteix (2007). WilcoxCV: an R package for fast variable selection in cross-validation. Bioinformatics 23:1702-1704.

}

\author{
  Anne-Laure Boulesteix (\url{http://www.ibe.med.uni-muenchen.de/organisation/mitarbeiter/020_professuren/boulesteix/index.html}) 
  
 

}
\seealso{\code{\link{wilcox.test}}, \code{\link{generate.split}}, \code{\link{generate.cv}},  \code{\link{wilcox.selection.split}}}

\examples{
# load WilcoxCV library
library(WilcoxCV)

# Generate data
x<-rnorm(100)
y<-sample(c(0,1),100,replace=TRUE)

# Generate 50 MCCV splits with ratio 2:1 for a data set including 90 observations
my.split<-generate.split(niter=50,n=90,ntest=30)

# Compute the Wilcoxon rank sum statistic for the 50 iterations.
wilcox.split(x=x,y=y,split=my.split,algo="new")
}
\keyword{htest}
