% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{graph_page}
\alias{graph_page}
\title{Graph a wiki page}
\usage{
graph_page(x, domain = "fr", namespace = "0")
}
\arguments{
\item{x}{Can be either a string defining a page title or a character vector,
and the function will return the graph of all the links beetween al the
pages included in the vector}

\item{domain}{The domain where is located the wiki}

\item{namespace}{The namespace pages the function will graph}
}
\value{
An igraph object
}
\description{
Creating a graph objet in witch an edge is a wiki page and a vertice is a
link beetween two wiki pages.
}
\examples{
\donttest{
# Graph of the 'Action' article in the french wiki.
graph_page('Action')
}

# Graphing a group of page
page <- c('Karl Marx','Classe sociale','Industrie')
# Return a graph where the 3 edges represents 'Karl Marx', 'Classe sociale' and 'Industrie', 
# and the vertices the link present or not beetween this pages.
g <- graph_page(page)
}

