% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_wblr.R
\name{plotly_wblr}
\alias{plotly_wblr}
\title{Interactive Probability Plot.}
\usage{
plotly_wblr(
  wblr_obj,
  susp = NULL,
  showConf = TRUE,
  showSusp = TRUE,
  showRes = TRUE,
  showGrid = TRUE,
  main = "Probability Plot",
  xlab = "Time to Failure",
  ylab = "Probability",
  probCol = "black",
  fitCol = "black",
  confCol = "black",
  intCol = "black",
  gridCol = "lightgray",
  signif = 3
)
}
\arguments{
\item{wblr_obj}{An object of class 'wblr'.}

\item{susp}{An optional numeric vector of suspension data.}

\item{showConf}{Show the confidence bounds (TRUE) or not (FALSE).}

\item{showSusp}{Show the suspensions plot (TRUE) or not (FALSE).}

\item{showRes}{Show the results table (TRUE) or not (FALSE).}

\item{showGrid}{Show grid (TRUE) or hide grid (FALSE).}

\item{main}{Main title.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{probCol}{Color of the probability values.}

\item{fitCol}{Color of the model fit.}

\item{confCol}{Color of the confidence bounds.}

\item{intCol}{Color of the intervals for interval censored models.}

\item{gridCol}{Color of the grid.}

\item{signif}{Significant digits of results}
}
\value{
The function returns no value.
}
\description{
This function creates an interactive probability plot for a wblr object.
}
\examples{
library(WeibullR)
library(WeibullR.plotly)
failures<-c(30, 49, 82, 90, 96)
obj<-wblr.conf(wblr.fit(wblr(failures)))
plotly_wblr(obj)
}
