% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stage-2.R
\name{causal.estimate}
\alias{causal.estimate}
\title{Estimate causal effects using FLEXOR or other methods}
\usage{
causal.estimate(
  S,
  Z,
  X,
  Y,
  B = 100,
  method,
  naturalGroupProp = NULL,
  num.random = 40,
  gammaMin = 0.001,
  gammaMax = (1 - 0.001),
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{S}{Vector of factor levels representing the study memberships. Takes values in \{1, ..., J\}.}

\item{Z}{Vector of factor levels representing the group memberships. Takes values in \{1, ..., K\}.}

\item{X}{Covariate matrix of \eqn{N} rows and \eqn{p} columns.}

\item{Y}{Matrix of \eqn{L} outcomes, with dimensions \eqn{N \times L}.}

\item{B}{Number of bootstrap samples for variance estimation. Default is 100.}

\item{method}{Pseudo-population method, i.e., weighting method. Take values in \code{FLEXOR}, \code{IC}, or \code{IGO}.}

\item{naturalGroupProp}{Relevant only for FLEXOR method: a fixed user-specified probability vector \eqn{\theta}.}

\item{num.random}{Relevant only for FLEXOR method: number of random starting points of \eqn{\gamma} in the two-step iterative procedure. Default is 40.}

\item{gammaMin}{Relevant only for FLEXOR method: Lower bound for each \eqn{\gamma_s} in the two-step iterative procedure. Default is 0.001.}

\item{gammaMax}{Relevant only for FLEXOR method: Upper bound for each \eqn{\gamma_s} in the two-step iterative procedure. Default is 0.999.}

\item{seed}{Seed for random number generation. Default is \code{NULL}.}

\item{verbose}{Logical; if \code{TRUE} (default), displays progress messages during computation to the console. Set to \code{FALSE} to suppress these messages.}
}
\value{
An S3 list object with the following components:

\describe{
\item{percentESS}{Percentage sample effective sample size (ESS) of the pseudo-population.}
\item{moments.ar}{An array of dimension \eqn{3 \times K \times L}, containing:
\itemize{
\item Estimated means, standard deviations (SDs), and medians (dimension 1),
\item For \eqn{K} groups (dimension 2),
\item And \eqn{L} counterfactual outcomes (dimension 3).
}}
\item{otherFeatures.v}{Estimated mean group differences for \eqn{L} outcomes.}
\item{collatedMoments.ar}{An array of dimension \eqn{3 \times K \times L \times B}, containing:
\itemize{
\item \code{moments.ar} of the \eqn{b}th bootstrap sample (dimensions 1–3),
\item For \eqn{B} bootstrap samples (dimension 4).
}}
\item{collatedOtherFeatures.mt}{A matrix of dimension \eqn{L \times B} containing:
\itemize{
\item \code{otherFeatures.v} of the \eqn{b}th bootstrap sample (dimension 1),
\item For \eqn{B} bootstrap samples (dimension 2).
}}
\item{collatedESS}{A vector of length \eqn{B}} containing percentage sample ESS for \eqn{B} bootstrap samples.
\item{method}{Pseudo-population method, i.e., weighting method.}
}
}
\description{
This function estimates causal effects based on the specified pseudo-population method.
The FLEXOR method involves an iterative two-step procedure.
}
\examples{
data(demo)
set.seed(1)
causal.estimate(S, Z, X, Y, B = 5, method = "IC", naturalGroupProp)

}
