% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stage-1.R
\name{balancing.weights}
\alias{balancing.weights}
\title{Compute balancing weights using FLEXOR or other methods}
\usage{
balancing.weights(
  S,
  Z,
  X,
  method,
  naturalGroupProp,
  num.random = 40,
  gammaMin = 0.001,
  gammaMax = (1 - 0.001),
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{S}{Vector of factor levels representing the study memberships. Takes values in \{1, ..., J\}.}

\item{Z}{Vector of factor levels representing the group memberships. Takes values in \{1, ..., K\}.}

\item{X}{Covariate matrix of \eqn{N} rows and \eqn{p} columns.}

\item{method}{Pseudo-population method, i.e., weighting method. Take values in \code{FLEXOR}, \code{IC}, or \code{IGO}.}

\item{naturalGroupProp}{Relevant only for FLEXOR method: a fixed user-specified probability vector \eqn{\theta}.}

\item{num.random}{Relevant only for FLEXOR method: number of random starting points of \eqn{\gamma} in the two-step iterative procedure. Default is 40.}

\item{gammaMin}{Relevant only for FLEXOR method: Lower bound for each \eqn{\gamma_s} in the two-step iterative procedure. Default is 0.001.}

\item{gammaMax}{Relevant only for FLEXOR method: Upper bound for each \eqn{\gamma_s} in the two-step iterative procedure. Default is 0.999.}

\item{seed}{Seed for random number generation. Default is \code{NULL}.}

\item{verbose}{Logical; Relevant only for FLEXOR method: if \code{TRUE} (default), displays progress messages during computation to the console. Set to \code{FALSE} to suppress these messages.}
}
\value{
An S3 list object with the following components:

\describe{
\item{wt.v}{\eqn{N} empirically normalized sample weights.}
\item{percentESS}{Percentage sample effective sample size (ESS) for the pseudo-population.}
}
}
\description{
This function calculates balancing weights based on the specified pseudo-population method.
}
\examples{
data(demo)
balancing.weights(S, Z, X, method = "IC", naturalGroupProp)

}
