% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coords_to_iso3.R
\name{coords_to_iso3}
\alias{coords_to_iso3}
\title{Convert coordinates to ISO country code}
\usage{
coords_to_iso3(lon, lat)
}
\arguments{
\item{lon}{A numeric vector giving the longitude of the sampling sites in Decimal Degrees.}

\item{lat}{A numeric vector giving the latitude of the sampling sites in Decimal Degrees.}
}
\value{
data.frame
}
\description{
This function takes a set of longitude and latitude coordinates and retrieves the administrative
units that each point lies within. The administrative units are given in the ISO-3166 Alpha-3 country code
standard (\url{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3}).
}
\examples{

coords_to_iso3(lon = c(90.37, 90.38, 90.37),
               lat = c(23.80, 23.80, 23.81))

}
