\encoding{latin1}
\name{W2CWM2C-package}
\alias{W2CWM2C-package}
\alias{W2CWM2C}
\docType{package}
\title{The W2CWM2C package is a set of functions that improves the 
graphical presentations of the functions 'wave.correlation' and
'spin.correlation' (wavelet cross correlation) (Waveslim package)
and the 'wave.multiple.correlation' and 
'wave.multiple.cross.correlation' (Wavemulcor package).
}
\description{
The W2CWM2C package improves the plots of the Wavelet (Cross) 
Correlation (bivariate case) from the \emph{waveleslim} package 
(Whitcher 2012) and the Wavelet Multiple (Cross) Correlation 
(multivariate case) from the \emph{wavemulcor} package (Fernandez-Macho 
2012). The W2CWM2C package also helps to handle the (input data)
multivariate time series easily as a list of N elements (times series)
and provides a multivariate data set (dataexample) to exemplify its use.
}
\details{
\tabular{ll}{
Package: \tab W2CWM2C\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2012-10-15\cr
License: \tab GPL (>= 2) \cr
LazyLoad: \tab yes\cr
}
The  W2CWM2C package contains four functions: the \emph{WC} (that 
perform and plot the Wavelet correlation, bivariate case), the 
\emph{WCC} (that perform and plot the Wavelet Cross Correlation, 
bivariate case), the \emph{WMC} (that perform and plot the Wavelet 
Multiple Correlation, multivariate case) and the \emph{WMCC} (that 
perform and plot the Wavelet Multiple Cross Correlation, 
multivariate case). 
}
\note{
 Dependencies: \emph{waveslim} and \emph{wavemulcor}. 
}
\author{
Josue Moises Polanco-Martinez.
Dpt. of Econometrics and Statistics,
& Instituto de Economia Publica,
University of the Basque Country (UPV(EHU), Agirre Lehendakari
etorb. 83, E48015 BILBAO, Spain.
Email: bcppomaj@ehu.es, jomopo@gmail.com \cr\cr
Acknowledgement:\cr 
Financial support from UPV/EHU Econometrics Research Group, Basque 
Government grant GIC07/53-IT-334-07 is gratefully acknowledged.
}
\references{
Fernandez-Macho, J.. Wavelet multiple correlation and 
cross-correlation: A multiscale analysis of euro zone stock 
markets. \emph{Physica A: Statistical Mechanics and its Applications}, 
391(4):1097-1104, 2012. \cr

Fernandez-Macho, J. (2012). Wavemulcor Reference manual. The 
Comprehensive R Archive Network (CRAN), http://cran.r-
project.org/web/packages/wavemulcor/index.html \cr 

Gencay, R., F. Selcuk and B. Whitcher (2001) \emph{An 
Introduction to Wavelets and Other Filtering Methods in Finance 
and Economics}, Academic Press.\cr 

Polanco-Martinez, J. and J. Fernandez-Macho (2012). An empirical 
analysis of some peripheral EU stock market indices: A Wavelet 
cross-correlation approach. Under review \emph{Physica A: 
Statistical Mechanics and its Applications}. (Manuscript Number: 
PHYSA-12867). \cr

Polanco-Martinez, J. and J. Fernandez-Macho (2012). The
package 'W2CWM2C': description, features and applications. To 
be submitted under review to \emph{Journal of Statistical 
Software}.\cr 

Whitcher, B., P. Guttorp, and D.B. Percival. Wavelet analysis of 
covariance with application to atmospheric time series. \emph{
Journal of Geophysical Research - Atmospheres}, 105(D11):941-962, 2000.\cr

Whitcher, B. (2012). Waveslim reference manual. The 
Comprehensive R Archive Network (CRAN), \cr
http://cran.r-project.org/web/packages/waveslim/index.html \cr
}
