% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveDur.R
\name{wave.dur}
\alias{wave.dur}
\title{Find the proportion of time when water surface is near a selected elevation}
\usage{
wave.dur(level, elevation, buffer = 0.050)
}
\arguments{
\item{level}{a numeric vector of water levels}

\item{elevation}{elevation(s) of interest (e.g., marsh platform, MHW). A vector of 
elevations is accepted. Elevation should be in the same vertical datum 
as \code{level} and have units of meters}

\item{buffer}{the vertical range used to calculate exposure. Default 
is 0.050 meters (5 cm)}
}
\value{
a vector of values representing the fraction of time in the entire dataset 
where the water surface is near the elevation of interest. Numerical range is from 0-1. NAs are omitted.
}
\description{
Find the proportion of time when water surface is near a selected elevation
}
\examples{
data(NL_6min_2013)

### an elevation of interest: 0.9117 m
MHW <- 0.9117

wave.dur(NL_6min_2013[, 2], MHW)

\dontrun{
### function also accepts and returns vectors
elevs           <- data.frame(elevs = c(-1000:1500) / 10^3)
elevs$wave.dur  <- wave.dur(NL_6min_2013[, 2], elevs$elevs)
plot(elevs ~ wave.dur, data = elevs)
}
}
