% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simon_pr.R
\name{Simon_oc}
\alias{Simon_oc}
\title{Operating Characteristics of Simon's Two-Stage Design}
\usage{
Simon_oc(
  prob,
  simon,
  type = c("minimax", "optimal", "n1", "maximax"),
  R,
  n1 = stop("must provide `n1`"),
  n = stop("must provide `n`"),
  r1 = stop("must provide `r1`"),
  r = stop("must provide `r`"),
  ...
)
}
\arguments{
\item{prob}{\strong{named} \link[base]{numeric} \link[base]{vector}, true response rate(s)}

\item{simon}{\link[clinfun]{ph2simon} object}

\item{type}{\link[base]{character} scalar, either
\code{'minimax'} for Simon's two-stage design with minimum total sample size (default),
\code{'optimal'} for minimum expected total sample size \strong{under \eqn{p_0}},
\code{'n1'} for minimum stage-1 sample size,
or \code{'maximax'} for maximum total sample size (as provided by user).}

\item{R}{\link[base]{integer} scalar, number of simulations}

\item{n1, n}{(optional) \link[base]{integer} scalars, stage 1 sample size \eqn{n_1}
and total sample size \eqn{n}.  Will be overridden if \code{simon} is given}

\item{r1, r}{(optional) \link[base]{integer} scalars, number of positive response
in Stage 1 \eqn{r_1} and overall \eqn{r} required \strong{exclusive}.
In other words, passing Stage 1 means observing \eqn{>r_1} positive response.
Will be overridden if \code{simon} is given}

\item{...}{potential parameters, currently not in use}
}
\value{
\link{Simon_oc} returns \link{Simon_oc} object
}
\description{
..
}
\details{
..
}
\examples{
library(clinfun)
(x = ph2simon(pu = .2, pa = .4, ep1 = .05, ep2 = .1)) 
Simon_oc(prob = c(A = .3, B = .2, C = .15), simon = x, type = 'minimax', R = 1e3L)
Simon_oc(prob = c(A = .3, B = .2, C = .15), simon = x, type = 'optimal', R = 1e3L)

}
\references{
\doi{10.1016/0197-2456(89)90015-9}
}
