% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVineSim.R
\name{RVineSim}
\alias{RVineSim}
\title{Simulation from an R-Vine Copula Model}
\usage{
RVineSim(N, RVM, U = NULL)
}
\arguments{
\item{N}{Number of d-dimensional observations to simulate.}

\item{RVM}{An \code{\link[=RVineMatrix]{RVineMatrix()}} object containing the information of
the R-vine copula model. Optionally, a length-\code{N} list of
\code{\link[=RVineMatrix]{RVineMatrix()}}  objects sharing the same structure, but possibly
different family/parameter can be supplied.}

\item{U}{If not \code{\link[=NULL]{NULL()}}, an (N,d)-matrix of \eqn{U[0,1]} random
variates to be transformed to the copula sample.}
}
\value{
An \code{N} x d matrix of data simulated from the given R-vine
copula model.
}
\description{
This function simulates from a given R-vine copula model.
}
\examples{

# define 5-dimensional R-vine tree structure matrix
Matrix <- c(5, 2, 3, 1, 4,
            0, 2, 3, 4, 1,
            0, 0, 3, 4, 1,
            0, 0, 0, 4, 1,
            0, 0, 0, 0, 1)
Matrix <- matrix(Matrix, 5, 5)

# define R-vine pair-copula family matrix
family <- c(0, 1, 3, 4, 4,
            0, 0, 3, 4, 1,
            0, 0, 0, 4, 1,
            0, 0, 0, 0, 3,
            0, 0, 0, 0, 0)
family <- matrix(family, 5, 5)

# define R-vine pair-copula parameter matrix
par <- c(0, 0.2, 0.9, 1.5, 3.9,
         0, 0, 1.1, 1.6, 0.9,
         0, 0, 0, 1.9, 0.5,
         0, 0, 0, 0, 4.8,
         0, 0, 0, 0, 0)
par <- matrix(par, 5, 5)

# define second R-vine pair-copula parameter matrix
par2 <- matrix(0, 5, 5)

# define RVineMatrix object
RVM <- RVineMatrix(Matrix = Matrix, family = family,
                   par = par, par2 = par2,
                   names = c("V1", "V2", "V3", "V4", "V5"))

# simulate a sample of size 300 from the R-vine copula model
set.seed(123)
simdata <- RVineSim(300, RVM)

}
\references{
Dissmann, J. F., E. C. Brechmann, C. Czado, and D. Kurowicka
(2013). Selecting and estimating regular vine copulae and application to
financial returns. Computational Statistics & Data Analysis, 59 (1), 52-69.
}
\seealso{
\code{\link[=RVineMatrix]{RVineMatrix()}}, \code{\link[=BiCopSim]{BiCopSim()}}
}
\author{
Jeffrey Dissmann
}
