% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build-query.R, R/utils-show_query.R
\name{show_query.vicmap_promise}
\alias{show_query.vicmap_promise}
\alias{show_query}
\title{Show The Query}
\usage{
\method{show_query}{vicmap_promise}(x, ...)
}
\arguments{
\item{x}{Object of class \code{vicmap_promise} (likely passed from \code{\link[=vicmap_query]{vicmap_query()}})}

\item{...}{Other parameters possibly used by generic}
}
\value{
object of class \code{vicmap_promise} (invisible: query printed to console), which is a 'promise' of the data that can  be returned if \code{collect()} is used
}
\description{
\code{show_query()} summarises the constructed query that has been passed to it by printing details
about the query in a human readable format.

See \code{dplyr::\link[dplyr:explain]{show_query}} for details.
}
\details{
The printed information consists of three sections:
\itemize{
\item{\strong{base url}}{ The base url of the query, this can be changed with options(vicmap.base_url = another_url)}
\item{\strong{body}}{ Lists the parameters of the WFS query, these can be modified through various functions such as \code{vicmap_query()}, \code{filter()}, \code{select()} and \code{head()}}
\item{\strong{full query url}}{ The constructed url of the final query to be collected}
}
}
\section{Methods (by class)}{
\itemize{
\item \code{vicmap_promise}: show_query.vicmap_promise
}}

\examples{
\donttest{
try(
vicmap_query(layer = "open-data-platform:hy_watercourse") \%>\%
head(50) \%>\%
show_query()
)
}
}
\keyword{internal}
