% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listFeatures.R
\name{listLayers}
\alias{listLayers}
\title{List Available WFS Layers}
\usage{
listLayers(...)
}
\arguments{
\item{...}{Additional arguments passed to \link[base]{grep}. The \code{pattern} argument can be used to search for specific layers with matching names or titles.}
}
\value{
data.frame
}
\description{
Lists layers available from the WFS geoserver. This is similar to sending the
WFS request of \code{getFeatureTypes}. \code{listLayers()} returns a data.frame with the 'Name' and title of the
layers available. The 'Name' is what is used within \code{vicmap_query()} while the title provides somewhat of a
description/clarification about the layer.
}
\examples{
\donttest{
try(
listLayers(pattern = "trees", ignore.case = TRUE)
)
}
}
