% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otherfunc.R
\name{surf_to_vol}
\alias{surf_to_vol}
\title{Surface to volume}
\usage{
surf_to_vol(surf_data, filename, VWR_check = TRUE)
}
\arguments{
\item{surf_data}{A vector object containing the surface data, either in fsaverage5 or fsaverage6 space. It can only be one row of vertices (no cohort surface data matrix).}

\item{filename}{A string object containing the desired name of the output .nii file (default is 'output.nii' in the R temporary directory (tempdir())).}

\item{VWR_check}{A boolean object specifying whether to check and validate system requirements. Default is TRUE.}
}
\value{
A .nii volume file
}
\description{
Converts surface data to volumetric data (.nii file)
}
\examples{
CTv = runif(20484,min=0, max=100);
surf_to_vol(CTv, filename = paste0(tempdir(),'/volume.nii'), VWR_check=FALSE)
}
