% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSsimulation.R
\name{SimpleSimulationVLtimeseries}
\alias{SimpleSimulationVLtimeseries}
\title{SimpleSimulationVLtimeseries}
\usage{
SimpleSimulationVLtimeseries(
  n = 200,
  lag = 5,
  YstFixInx = 110,
  YfnFixInx = 170,
  XpointFixInx = 100,
  arimaFlag = TRUE
)
}
\arguments{
\item{n}{is length of time series.}

\item{lag}{is a time lag between \code{X} and \code{Y} s.t. \code{Y[t]} is approximately \code{X[t-lag]}.}

\item{YstFixInx}{is the starting point of variable lag part.}

\item{YfnFixInx}{is the end point of variable lag part.}

\item{XpointFixInx}{is a point in X s.t. \code{ Y[YstFixInx:YfnFixInx]= X[XpointFixInx] }.}

\item{arimaFlag}{is ARMA model flag. If it is true, then \code{X} is generated by ARMA model.
If it is false, then  \code{X} is generated by sampling of the standard normal distribution.}
}
\value{
This function returns a list of time series \code{X,Y} where \code{X} VL-Granger-causes \code{Y}.
}
\description{
SimpleSimulationVLtimeseries is a support function for generating time series \code{X,Y} where \code{X} VL-Granger-causes \code{Y}.
}
\examples{
# Generate simulation data
TS <- SimpleSimulationVLtimeseries()

}
