#' @title  SimpleSimulationVLtimeseries
#'
#' @description
#'
#' SimpleSimulationVLtimeseries is a support function for generating time series \code{X,Y} where \code{X} VL-Granger-causes \code{Y}.
#'
#' @param n is length of time series.
#' @param lag is a time lag between \code{X} and \code{Y} s.t. \code{Y[t]} is approximately \code{X[t-lag]}.
#' @param YstFixInx is the starting point of variable lag part.
#' @param YfnFixInx is the end point of variable lag part.
#' @param XpointFixInx is a point in X s.t. \code{ Y[YstFixInx:YfnFixInx]= X[XpointFixInx] }.
#' @param arimaFlag is ARMA model flag. If it is true, then \code{X} is generated by ARMA model.
#' If it is false, then  \code{X} is generated by sampling of the standard normal distribution.
#'
#' @return This function returns a list of time series \code{X,Y} where \code{X} VL-Granger-causes \code{Y}.
#'
#' @examples
#' # Generate simulation data
#' TS <- SimpleSimulationVLtimeseries()
#'
#'@export
SimpleSimulationVLtimeseries<-function(n=200,lag=5,YstFixInx=110,YfnFixInx=170, XpointFixInx=100,arimaFlag=TRUE)
{
  X <- rep(0, n + lag)
  Y <- rep(0, n + lag)


  for (i in seq(n)) {
    if(arimaFlag == FALSE) # using normal generator
    {
      X[i + 1] <- rnorm(1, 0, 1)
    }
    else
      X[i + 1] <- 0.2 * X[i] + rnorm(1, 0, 1)
    Y[i + lag] <- X[i] + rnorm(1, 0, 0.1)
  }

  Y[YstFixInx:YfnFixInx]<-X[XpointFixInx]

  X <- X[-(1:lag)]
  Y <- Y[-(1:lag)]
  return(list(X=X,Y=Y))
}
