% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{orderData}
\alias{orderData}
\title{Re-Order Data.Frame}
\usage{
orderData(Data, trms, order.data = TRUE, exclude.numeric = TRUE,
  quiet = FALSE)
}
\arguments{
\item{Data}{(data.frame) with input data intented to put into standard-order}

\item{trms}{(formula, terms) object speciying a model to be fitted to \code{Data}}

\item{order.data}{(logical) TRUE = variables will be increasingly ordered, FALSE = order of
the variables remains as is}

\item{exclude.numeric}{(logical) TRUE = numeric variables will not be included in the reordering,
which is required whenever this variable serves as covariate in a LMM, 
FALSE = numeric variables will also be converted to factors, useful in 
VCA-analysis, where all variables are interpreted as class-variables}

\item{quiet}{(logical) TRUE = omits any (potentially) informative output regarding
re-ordering and type-casting of variables}
}
\description{
Functions attempts to standardize input data for linear mixed model analyses
to overcome the problem that analysis results sometimes depend on ordering of
the data and definition of factor-levels.
}
\examples{
\dontrun{
# random ordering
data(dataEP05A2_1)
dat <- dataEP05A2_1
levels(dat$day) <- sample(levels(dat$day))
# this has direct impact e.g. on order of estimated effects
fit <- anovaVCA(y~day/run, dat, order.data=FALSE)
ranef(fit)
# to guarantee consistent analysis results
# independent of the any data orderings option
# 'order.data' is per default set to TRUE:
fit <- anovaVCA(y~day/run, dat)
ranef(fit)
# which is identical to:
fit2 <- anovaVCA(y~day/run, orderData(dat, y~day/run), order.data=FALSE)
ranef(fit2)
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
