% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{buildList}
\alias{buildList}
\title{Build a Nested List.}
\usage{
buildList(Data, Nesting, Current, resp, keep.order = TRUE, useVarNam = TRUE,
  sep = "", na.rm = TRUE, Points = list(pch = 16, cex = 0.5, col =
  "black"))
}
\arguments{
\item{Data}{(data.frame) with the data}

\item{Nesting}{(character) vector specifying the nesting structure with the top-level variable name
as 1st element and the variance component one above the residual error as last element}

\item{Current}{(character) string specifying the current level which has to be processed}

\item{resp}{(character) string specifying the name of the response variable (column in 'Data')}

\item{keep.order}{(logical) TRUE = the ordering of factor-levels is kept as provided by 'Data', FALSE = factor-levels are sorted on 
and within each level of nesting}

\item{useVarNam}{(logical) TRUE = each factor-level specifier is pasted to the variable name of the current variable and used as list-element name, 
FALSE = factor-level specifiers are used as names of list-elements; the former is useful when factor levels are indicated
as integers, e.g. days as 1,2,..., the latter is useful when factor levels are already unique, e.g. day1, day2, ...}

\item{sep}{(character) string specifying the separator-string in case useVarNam=TRUE}

\item{na.rm}{(logical) TRUE = NAs will be removed before computing the descriptive statistics AND NAs will be omitted when counting number of elements, 
FALSE = if there are NAs, this will result in NAs for the descriptive statistics}

\item{Points}{(list) specifying all parameters applicable to function 'points', used to specify scatterplots per lower-end factor-level
(e.g. run/part in EP05-A2 experiments). If list-element "col" is itself a list with elements "var" and "col", where the former
specifies a variable used for assigning colors "col" according to the class-level of "var", point-colors can be used for indicating
specific sub-classes not addressed by the model/design (see examples).}
}
\value{
(list) which was recursively built, representing the data of the fully-nested as hierarchy
}
\description{
Function \code{buildList} creates a nested-list reflecting the hierarchical structure of a fully-nested model, respectively, the imputed
hierarchical structure of the data (see details).
}
\details{
This function is not intended to be used directly and serves as helper function for \code{\link{varPlot}}.
Each factor-level, on each level of nesting is accompanied with a set of descriptive statistics, such as mean, median, var, sd, ... which can be evaluated
later on. These information are used in function \code{varPlot}, which implements a variability chart.
Note, that this function is also used if data does not correspond to a fully-nested design, i.e. the hierarchical structure is
inferred from the model formula. The order of main factors (not nested within other factors) appearing in the model formula determines
the nesting structure imputed in order to plot the data as variability chart.
}
\examples{

\dontrun{
# load data (CLSI EP05-A2 Within-Lab Precision Experiment)
data(dataEP05A2_3)

# build a list representing the hierarichal structure of a fully-nested model
# there needs to be a distinct hierarchy for being able to plot the data
# as variability chart (this function is not exported)
lst <- VCA:::buildList(Data=dataEP05A2_3, Nesting=c("day", "run"), Current="day", resp="y")
}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
