% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/img2varmer.R
\name{img2varmer}
\alias{img2varmer}
\title{Compare two images}
\usage{
img2varmer(uhat.img, v.img)
}
\arguments{
\item{uhat.img}{The interpolated image as a raster or brick.}

\item{v.img}{The satellite image as a raster or brick.}
}
\value{
If the images have the same extension, resolution, coordinate reference system, columns and rows.

A list containing two data frames (uhat and v) in the necessary format to varmer function (x,y,layer1,layer2).

If the images has not the same values an error message is returned.
}
\description{
The function compare two raster or bricks with different z values(uhat and v images)
It check if the images has the same extension, resolution, coordinate reference system, columns and rows.
}
\examples{
library(raster)
data(uhat_raster,"VARMER")
force(uhat.raster)
data(v_raster,"VARMER")
force(v.raster)
img2varmer(uhat.raster,v.raster)
}
