% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_VALERIE_PlotPSI_A5SS_TwoGroups.R
\name{PlotPSI.A5SS.TwoGroups}
\alias{PlotPSI.A5SS.TwoGroups}
\title{Percent spliced-in (PSI) visualization for alternative 5' splice sites (A5SS)}
\usage{
PlotPSI.A5SS.TwoGroups(
  object,
  SampleInfo,
  ExonInfo,
  statistical.test = c("wilcox", "t.test"),
  multiple.testing = c("holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr",
    "none"),
  Plots,
  plot.width,
  plot.height
)
}
\arguments{
\item{object}{Object of class rehab generated using \code{ComputePSI}.}

\item{SampleInfo}{Tab-delimited file describing the naming and grouping of the single cells. First column should contain the names of the binary alignment map (BAM) files. Second column indicates the grouping for each single cell, namely Group1 and Group2. Third column indicates the group names. Example file provided in extdata directory of the package.}

\item{ExonInfo}{Tab-delimited file describing the alternative splicing events. First column contains the alternative splicing nomenclature as per BRIE (Huang et al, Genome Biology, 2019) or MISO (Katz et al, Nature Methods, 2010). Second column indicates the type of alternative splicing event, namely SE, MXE, RI, A5SS, A3SS. Third column contains the gene name or any personal notation. Example file provided in extdata directory of the package.}

\item{statistical.test}{Method for comparising PSI values at each genomic coordinates between two groups of single cells.}

\item{multiple.testing}{Method for adjusting p-values for multiple comparisons.}

\item{Plots}{Folder to output PSI plots.}

\item{plot.width}{Width of outplot plots.}

\item{plot.height}{Height of outplot plots.}
}
\value{
For each alternative splicing event, a single plot consisting of three subplots arranged from top to bottom is returned. Bottom subplot is a line graph of PSI means at each genomic coordinate for two groups of single cells. Middle subplot is a line graph of p-values corresponding to the comparison of PSI values at each genomic coordinate between two groups of single cells. Top subplot is a heatmap of PSI values at each genomic coordinate across all single cells. Location of plots as per specified in the \code{Plots} argument.
}
\description{
\code{PlotPSI.A5SS} visualizes percent spliced-in (PSI) for each genomic coordinate for alternative 5' splice site (A5SS) event across two groups of single cells.
}
\details{
This function visualizes the percent spliced-in (PSI) at each genomic coordinate encompassing the alternative exon and its flanking constitutive exons for each single cell in the form of a heatmap. The PSI mean for the respective groups are also display in the form of a line graph to summarize the PSI distributions of the respective groups. Pair-wise comparison of PSI at each genomic coordinate is performed using either the parametric student t-test or non-parameteric Wilcoxon rank-sum test. The p-values can be adjusted for multiple testing using the \code{p.adjust} function.
}
\examples{
PSI <- readRDS(system.file("extdata/PSI", "PSI_RED_Two_Groups_small.rds", package="VALERIE"))
PlotPSI.A5SS.TwoGroups(PSI, SampleInfo=system.file("extdata/Sample_Info",
  "Sample_Info_RED_Two_Groups.txt", package="VALERIE"),
  ExonInfo=system.file("extdata/Exon_Info", "Exon_Info_RED_small.txt", package="VALERIE"),
  statistical.test="wilcox",  multiple.testing="fdr",
  Plots=tempdir(), plot.width=5, plot.height=8)
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
