% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint_surv_VA.R
\name{joint_ms_ptr}
\alias{joint_ms_ptr}
\title{Creates a joint_ms Object to Estimate a Joint Survival and Marker Model}
\usage{
joint_ms_ptr(
  markers = list(),
  survival_terms = list(),
  max_threads = 1L,
  quad_rule = NULL,
  cache_expansions = TRUE,
  gh_quad_rule = NULL,
  ders = NULL
)
}
\arguments{
\item{markers}{either an object from \code{\link{marker_term}} or a list
of such objects.}

\item{survival_terms}{either an object from \code{\link{surv_term}} or a list
of such objects.}

\item{max_threads}{maximum number of threads to use.}

\item{quad_rule}{list with nodes and weights for a quadrature rule for the
integral from zero to one.}

\item{cache_expansions}{\code{TRUE} if the expansions in the numerical
integration in the survival parts of the lower bound should be cached (not
recomputed). This requires more memory and may be an advantage
particularly with
expansions that take longer to compute (like \code{\link{ns_term}} and
\code{\link{bs_term}}). The computation time may be worse particularly if
you use more threads as the CPU cache is not well utilized.}

\item{gh_quad_rule}{list with two numeric vectors called node and weight
with Gauss–Hermite quadrature nodes and weights to handle delayed entry.
A low number of quadrature nodes and weights is used when \code{NULL} is
passed.
This seems to work well when delayed entry happens at time with large
marginal survival probabilities. The nodes and weights can be obtained e.g.
from \code{fastGHQuad::gaussHermiteData}.}

\item{ders}{a \code{\link{list}} of \code{\link{list}}s with
\code{\link{integer}} vectors for how
the survival outcomes are linked to the markers. 0 implies present values,
-1 is integral of, and 1 is the derivative. \code{NULL} implies the present
value of the random effect for all markers. Note that the number of integer
vectors should be equal to the number of markers.}
}
\value{
An object of \code{joint_ms} class with the needed C++ and R objects
to estimate the model.
}
\description{
Creates a joint_ms Object to Estimate a Joint Survival and Marker Model
}
\examples{
# load in the data
library(survival)
data(pbc, package = "survival")

# re-scale by year
pbcseq <- transform(pbcseq, day_use = day / 365.25)
pbc <- transform(pbc, time_use = time / 365.25)

# create the marker terms
m1 <- marker_term(
  log(bili) ~ 1, id = id, data = pbcseq,
  time_fixef = bs_term(day_use, df = 5L),
  time_rng = poly_term(day_use, degree = 1L, raw = TRUE, intercept = TRUE))
m2 <- marker_term(
  albumin ~ 1, id = id, data = pbcseq,
  time_fixef = bs_term(day_use, df = 5L),
  time_rng = poly_term(day_use, degree = 1L, raw = TRUE, intercept = TRUE))

# base knots on observed event times
bs_term_knots <-
  with(pbc, quantile(time_use[status == 2], probs = seq(0, 1, by = .2)))

boundary <- c(bs_term_knots[ c(1, length(bs_term_knots))])
interior <- c(bs_term_knots[-c(1, length(bs_term_knots))])

# create the survival term
s_term <- surv_term(
  Surv(time_use, status == 2) ~ 1, id = id, data = pbc,
  time_fixef = bs_term(time_use, Boundary.knots = boundary, knots = interior))

# create the C++ object to do the fitting
model_ptr <- joint_ms_ptr(
  markers = list(m1, m2), survival_terms = s_term,
  max_threads = 2L)
}
\seealso{
\code{\link{joint_ms_opt}}, \code{\link{joint_ms_lb}},
\code{\link{joint_ms_hess}}, and \code{\link{joint_ms_start_val}}.
}
