% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tg.roc.R
\name{TG.ROC}
\alias{TG.ROC}
\title{Two-Graphs Receiving Operating Characteristics.}
\usage{
TG.ROC(
  ref,
  test,
  Se.criterion = 0.9,
  Sp.criterion = 0.9,
  model = c("none", "binormal"),
  plot = FALSE,
  position.legend = "left",
  cex.legend = 1
)
}
\arguments{
\item{ref}{The reference standard. A column in a data frame or a vector
indicating the classification by the reference test. The reference standard
must be coded either as 0 (absence of the condition) or 1 (presence of the
condition).}

\item{test}{The numeric test scores under evaluation. Higher scores indicate
the presence of the targeted disease. Please use negated values when lower
values indicate the presence of the targeted disease.}

\item{Se.criterion}{Default = .95. Minimum desired value of Se.}

\item{Sp.criterion}{Default = .95. Minimum desired value of Sp.}

\item{model}{Default = 'none'. Model to use, either binormal or none
(non-parametric)}

\item{plot}{Defaults= FALSE. Whether a plot is shown for Se and Sp against
the thresholds.}

\item{position.legend}{Default: 'left'. Position of the legend. Most used
values: "left", "right".}

\item{cex.legend}{Default: 1. Relative size of the legend.}
}
\value{
Thresholds for the intermediate zone. Lower threshold < Test scores <
  Upper threshold is the intermediate range. The range of test values >=
  lower limit provides the desired positive accuracy (Se.citerion), while the
  range of test values <= upper limit provides the desired negative accuracy
  (Sp.citerion).
}
\description{
The function supports the determination and plot of the
  sensitivity and specificity against the possible thresholds and shows an
  intermediate range of test results that is considered as less accurate.
}
\details{
This function implements a non-parametric and a bi-normal model. See
  Landsheer(2018) for an evaluative description.

  Warning: Although the test scores <= the lower limit and the test scores >=
  the upper limit are interpreted for respectively negative and positive
  classifications, the range of test values >= lower limit provides the
  desired positive accuracy (Se.citerion), while the range of test values <=
  upper limit provides the desired negative accuracy (Sp.citerion). This is
  problematic for its double count: the values in the intermediate zone are
  needed both for the desired Se and for the desired Sp value.

  Please note that the definition of the intermediate interval deviates from
  the definition of an uncertain interval.

  The TG-ROC (Two Graphs Receiver Operating Characteristics) plot shows the
  diminishing values of Se and increasing values of Sp against the possible
  thresholds.
}
\examples{
ref = c(rep(0,100), rep(1,100))
test = c(rnorm(100, 0, 1), rnorm(100, 1, 1))
TG.ROC(ref, test, model='binormal', plot=TRUE)
TG.ROC(ref, test, model='none', plot=TRUE)
}
\references{
Greiner, M. (1995). Two-graph receiver operating characteristic
  (TG-ROC): A Microsoft-EXCEL template for the selection of cut-off values in
  diagnostic tests. Journal of Immunological Methods, 185(1), 145-146.

  Greiner, M. (1996). Two-graph receiver operating characteristic (TG-ROC):
  Update version supports optimisation of cut-off values that minimise
  overall misclassification costs. Journal of Immunological Methods, 191(1),
  93-94.

  Landsheer, J. A. (2018). The Clinical Relevance of Methods for Handling
  Inconclusive Medical Test Results: Quantification of Uncertainty in Medical
  Decision-Making and Screening. Diagnostics, 8(2), 32.
  https://doi.org/10.3390/diagnostics8020032
}
