% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStarsAtHighDensityRegion.R
\name{getStarsAtHighestDensityRegion}
\alias{getStarsAtHighestDensityRegion}
\title{Perform cut in the membership list based on the 2D space distribution}
\usage{
getStarsAtHighestDensityRegion(ocdata_out, threshold=2, posIdx=c(1,2), 
plotAnalysis=FALSE, verbose=FALSE)
}
\arguments{
\item{ocdata_out}{a data frame to use}

\item{threshold}{a double with the thresholding level}

\item{posIdx}{an array of integers indicating the columns of the data frame containing the spatial positions}

\item{plotAnalysis}{a boolean indicating if the anaylsis should be plotted}

\item{verbose}{a boolean indicating if the code should be verbose}
}
\value{
A data frame with the objects which were selected from \code{ocdata_out}
}
\description{
\code{getStarsAtHighestDensityRegion} will compute the 2D Kernel Density 
Estimation for the requested subset of data and will return only the stars in the most
dense region.
}
\examples{
# Create a simple data set
toyDataDF <- data.frame(x=runif(50, 0, 10), y=runif(50, 0, 10), resMclust.class=rep(1, 50))
toyDataDF <- rbind(toyDataDF, data.frame(x=rnorm(50, 2, 3), 
                   y=rnorm(50, 4, 3), resMclust.class=rep(1, 50)))

# Perform the XY density based cut
toyRes <- getStarsAtHighestDensityRegion(toyDataDF)

# Clean the environment
rm(list=c("toyDataDF", "toyRes"))
 
}
\author{
Alberto Krone-Martins, Andre Moitinho
}
\keyword{utilities}
