% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRINT.R
\name{print.UPG.Logit}
\alias{print.UPG.Logit}
\title{Print information for UPG.Logit objects}
\usage{
\method{print}{UPG.Logit}(x, ...)
}
\arguments{
\item{x}{an object of class \code{UPG.Logit}.}

\item{...}{other print parameters.}
}
\description{
\code{print} provides some basic information about an \code{UPG.Logit} object.
}
\examples{
\donttest{
# estimate a logit model using example data
library(UPG)
data(lfp)
y = lfp[,1]
X = lfp[,-1]
results.logit = UPG(y = y, X = X, type = "logit", verbose=TRUE)
print(results.logit)
}
}
\seealso{
\code{\link{summary.UPG.Logit}} to summarize the estimates of a discrete choice model from an \code{UPG.Logit} object and create tables.
\code{\link{predict.UPG.Logit}} to predict probabilities from a discrete choice model from an \code{UPG.Logit} object.
\code{\link{plot.UPG.Logit}} to plot the results of a discrete choice model from an \code{UPG.Logit} object.
}
\author{
Gregor Zens
}
