% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{GenParetoPars}
\alias{GenParetoPars}
\title{Generalised Pareto distribution parameter estimates}
\usage{
GenParetoPars(x = NULL, mle = FALSE, L1, LCV, LSKEW)
}
\arguments{
\item{x}{numeric vector. The sample}

\item{mle}{logical argument with a default of FALSE. If FALSE the parameters are estimated with Lmoments, if TRUE the parameters are estimated by maximum likelihood estimation}

\item{L1}{first Lmoment}

\item{LCV}{linear coefficient of variation}

\item{LSKEW}{linear skewness}
}
\value{
Parameter estimates (location, scale, shape)
}
\description{
Estimated parameters from a sample (with Lmoments or maximum likelihood estimation) or from L1 (first L-moment), Lcv (linear coefficient of variation), and LSkew (linear skewness)
}
\details{
The L-moment estimated parameters are by the method detailed in 'Hosking J. Wallis J. 1997 Regional Frequency Analysis: An Approach Based on L-moments. Cambridge University Press, New York'
}
\examples{
#Get a peaks over threshold sample and estimate the parameters using Lmoments
ThamesPOT <- ThamesPOT <- POTextract(ThamesPQ[,c(1,3)], thresh = 0.90)
GenParetoPars(ThamesPOT$peak)
#Estimate parameters using MLE
GenParetoPars(ThamesPOT$peak, mle = TRUE)
#calculate Lmoments and estimate the parmeters with L1, Lcv and Lskew
LMoments(ThamesPOT$peak)
#store linear moments in an object
LPars <- as.numeric(LMoments(ThamesPOT$peak))[c(1,5,6)]
GenParetoPars(L1 = LPars[1], LCV = LPars[2], LSKEW = LPars[3])
}
\author{
Anthony Hammond
}
