% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{ImportCDs}
\alias{ImportCDs}
\title{Import catchment descriptors from .CD3 files}
\usage{
ImportCDs(x)
}
\arguments{
\item{x}{the CD3 file path}
}
\value{
A data.frame with columns; Descriptor and Value.
}
\description{
Imports catchment descriptors from CD3 files either from an FEH webservice download or from the Peakflows dataset downloaded from the national river flow archive (NRFA) website
}
\details{
The CD3 files downloaded from the FEH webserver are formatted differently from the CD3 files of the peak flows dataset, this function is coded to import either, given the correct file path. File paths for importing data require forward slashes. On some operating systems, such as windows, the copy and pasted file paths will have backward slashes and would need to be changed accordingly.
}
\examples{
#Import catchment descriptors from a NRFA peakflows CD3 file and display in console
\dontrun{CDs.4003 <- ImportCDs("C:/Data/NRFAPeakFlow_v9/Suitable for QMED/4003.CD3", web = FALSE)}
\dontrun{CDs.4003}
#Import catchment descriptors from a FEH webserver CD3 file and display CDs in the console
\dontrun{CDs.MySite <- ImportCDs("C:/Data/FEH_Catchment_384200_458200.CD3")}
}
\author{
Anthony Hammond
}
