% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{AMextract}
\alias{AMextract}
\title{Annual maximum extraction}
\usage{
AMextract(x, Plot = TRUE)
}
\arguments{
\item{x}{a data.frame with dates (or POSIXct) in the first column and variable in the second}

\item{Plot}{a logical argument with a default of TRUE. If TRUE the extracted annual maximum is plotted}
}
\value{
a data.frame with columns; WaterYear and AM
}
\description{
Extracts the annual maximum peaks from a data.frame which has dates in the first column and variable in the second.
}
\details{
The peaks are extracted based on the UK hydrological year, which starts October 1st and ends September 30th. If there are NAs for full years in the data, an -Inf will be returned for that year.
}
\examples{
#Extract the Thames AMAX daily mean flow and display the first six rows
ThamesAM <- AMextract(ThamesPQ[,c(1,3)])
head(ThamesAM)
}
\author{
Anthony Hammond
}
