% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{GenParetoGF}
\alias{GenParetoGF}
\title{Generalised Pareto distribution growth factors}
\usage{
GenParetoGF(lcv, lskew, RP, ppy = 1)
}
\arguments{
\item{lcv}{linear coefficient of variation}

\item{lskew}{linear skewness}

\item{RP}{return period}

\item{ppy}{peaks per year}
}
\value{
Generalised Pareto estimated growth factor
}
\description{
Estimated growth factors as a function of return period, with inputs of Lcv & LSkew (linear coefficient of variation & linear skewness)
}
\details{
Growth factors (GF) are calculated by the method outlined in the Flood Estimation Handbook, volume 3, 1999. The average number of peaks per year argument (ppy) is for the function to convert from the peaks over threshold (POT) scale to the annual scale. For example, if there are 3 peaks per year, the probability associated with the 100-yr return period estimate would be 0.01/3 (i.e. an RP of 300 on the POT scale) rather than 0.01.
}
\examples{
#Get POT flow data from the Thames at Kingston (noting the no. peaks per year).
#Then estimate the 100-year growth factor with lcv and lskew estimates
TPOT <- POTextract(ThamesPQ[,c(1,3)], thresh = 0.90)
GenParetoGF(Lcv(TPOT$peak), LSkew(TPOT$peak), RP = 100, ppy = 1.867)
#multiply by the median of the POT data for an estimate of the 100-yr flood
GenParetoGF(Lcv(TPOT$peak), LSkew(TPOT$peak), RP = 100, ppy = 1.867)*median(TPOT$peak)
}
\author{
Anthony Hammond
}
