% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{XenaDownload}
\alias{XenaDownload}
\title{Download datasets form UCSC Xena datasets.}
\usage{
XenaDownload(xquery, destdir = tempdir(), force = FALSE, ...)
}
\arguments{
\item{xquery}{a tibble object generated by \code{XenaQuery} function.}

\item{destdir}{specify a location to store download data. Default is system temp directory.}

\item{force}{logical. if \code{TRUE}, force to download data no matter whether files exist.
Default is \code{FALSE}.}

\item{...}{other argument to \code{download.file} function}
}
\value{
a \code{tibble}
}
\description{
Avaliable datasets list: <https://xenabrowser.net/datapages/>
}
\examples{
xe = XenaGenerate(subset = XenaHostNames == "TCGA")
hosts(xe)
xe_query = XenaQuery(xe)
\donttest{
xe_download = XenaDownload(xe_query)
}
}
\author{
Shixiang Wang <w_shixiang@163.com>
}
