% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_identifier.R
\name{vis_identifier_cor}
\alias{vis_identifier_cor}
\title{Visualize Identifier-Identifier Correlation}
\usage{
vis_identifier_cor(
  dataset1,
  id1,
  dataset2,
  id2,
  samples = NULL,
  use_ggstats = FALSE,
  use_simple_axis_label = TRUE,
  line_color = "blue",
  alpha = 0.5,
  ...
)
}
\arguments{
\item{dataset1}{the dataset to obtain \code{id1}.}

\item{id1}{the first molecule identifier.}

\item{dataset2}{the dataset to obtain \code{id2}.}

\item{id2}{the second molecule identifier.}

\item{samples}{default is \code{NULL}, can be common sample names for two datasets.}

\item{use_ggstats}{if \code{TRUE}, use \href{https://github.com/IndrajeetPatil/ggstatsplot}{ggstatsplot} package for plotting.}

\item{use_simple_axis_label}{if \code{TRUE} (default), use simple axis labels.
Otherwise, data subtype will be labeled.}

\item{line_color}{set the color for regression line.}

\item{alpha}{set the alpha for dots.}

\item{...}{other parameters passing to \href{http://rpkgs.datanovia.com/ggpubr/reference/ggscatter.html}{ggscatter}.}
}
\value{
a (gg)plot object.
}
\description{
NOTE: the dataset must be dense matrix in UCSC Xena data hubs.
}
\examples{
\dontrun{
dataset <- "TcgaTargetGtex_rsem_isoform_tpm"
id1 <- "TP53"
id2 <- "KRAS"
vis_identifier_cor(dataset, id1, dataset, id2)

samples <- c(
  "TCGA-D5-5538-01", "TCGA-VM-A8C8-01",
  "TCGA-ZN-A9VQ-01", "TCGA-EE-A17X-06",
  "TCGA-05-4420-01"
)
vis_identifier_cor(dataset, id1, dataset, id2, samples)

dataset1 <- "TCGA-BLCA.htseq_counts.tsv"
dataset2 <- "TCGA-BLCA.gistic.tsv"
id1 <- "TP53"
id2 <- "KRAS"
vis_identifier_cor(dataset1, id1, dataset2, id2)
}
}
