\name{run_simulation_simsurv}
\alias{run_simulation_simsurv}
\title{Run Clinical Trial Simulations Based on survival data generated by simsurv package}
\usage{
run_simulation_simsurv(samplesize, rand_ratio=c(1,1), blocksize, factors=NULL, 
accrual_interval=NULL,accrual_rate=NULL,  eventtarget=NULL,maxlpfollowup=NULL, 
N_simulation=1,alpha=0.05,simsurv1=NULL, simsurv2=NULL)

  

}

\arguments{
  \item{samplesize}{Total number of patients in the simulated clinical trial}
  \item{rand_ratio}{Randomization ratio between control and treatment}
  \item{blocksize}{The value of this parameter is used to define the size of the randomizaiton blocks. The actual blocksize is number of treatment levels mutipled by this parameter. Please refer to "blockrand" package for detailed usage.}
  \item{factors}{stratification factors. Default is NULL}
  \item{accrual_interval}{Time windows for accrual}
  \item{accrual_rate}{accrual rate for each accrual time window}
  \item{eventtarget}{Number of target events}
  \item{maxlpfollowup}{maximum follow up time for the last enrolled patient}
  \item{N_simulation}{number of simulations to run}
  \item{alpha}{Two sided alpha for testing power calculation}
  \item{simsurv1}{simsurv command to generate survival time. Design matrix should set to "x". Please refer to examples.}
  \item{simsurv2}{simsurv command to gendrate dropout time.}
}

\value{
 \item{TrilInfo}{Summary of the simulated trial data}
 \item{ModelResult}{Cox model results comparing treatment vs control}
 \item{StraModelResult}{Stratified Cox model results comparing treatment vs control}
 \item{Data}{simulated dataset only if "N_simulateion" is set to 1}
}


\description{
Runs single or mutiple clinical trial (Time to event endpoint) simulations based survival time generated by simsurv package. Trial data summary will be provied for each simulation. Cox model will be fitted afther trial simulation. If stratification factors were provided, stratified cox model results will also be provided. If "N_simulation" is set to 1, one simulation dataset will be generated.
}
\examples{


# Example 1, compare simsurv and TwoArmSurvSim, trtHR=0.7 eventtarget=247, power should be 0.8 

f1<-list(name='Gender', N_level=2, prevalence=c(0.5,0.5), HR=c(1,0.9), strata=TRUE)
factors=list(f1)


samplesize = 400
blocksize = 2
accrual_interval = c(0,5,10)
accrual_rate = c(5,10,20)
eventtarget = 247
N_simulation = 1


# Simsurv

simsurv1 <- "simsurv(lambdas = 0.03, gammas = 1, 
betas = c(trt = log(0.7),Gender.1=log(0.9)),x = x)"
simsurv2 <-NULL

out<-run_simulation_simsurv(samplesize=samplesize,blocksize=blocksize,factors=factors,
accrual_interval=accrual_interval,accrual_rate=accrual_rate, eventtarget=eventtarget,
N_simulation=N_simulation,simsurv1=simsurv1,simsurv2=simsurv2)

# example 2,  Time dependent treatment effect. 
# h(t)=h0(t)*exp(beta0*x+beta1*x*log(t)).  beta0=log(0.7), beta1=0.15

simsurv1 <- "simsurv( lambdas = 0.1, gammas = 1.5,betas = c(trt = log(0.7)),
x = x, tde = c(trt = 0.15),tdefunction = \"log\")"
simsurv2 <-NULL





}
