% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmvt.R
\name{tmvt}
\alias{tmvt}
\title{Multivariate truncated Student distribution}
\arguments{
\item{n}{number of observations}

\item{x, q}{vector or matrix of quantiles}

\item{B}{number of replications for the (quasi)-Monte Carlo scheme}

\item{log}{logical; if \code{TRUE}, probabilites and density are given on the log scale.}

\item{mu}{vector of location parameters}

\item{sigma}{scale matrix}

\item{df}{degrees of freedom}

\item{lb}{vector of lower truncation limits}

\item{ub}{vector of upper truncation limits}

\item{type}{string, either of \code{mc} or \code{qmc} for Monte Carlo and quasi Monte Carlo, respectively}
}
\value{
\code{dtmvt} gives the density, \code{ptmvt} gives the distribution function, \code{rtmvt} generate random deviates.
}
\description{
Density, distribution function and random generation for the multivariate truncated Student distribution
with location vector \code{mu}, scale matrix \code{sigma}, lower truncation limit
\code{lb}, upper truncation limit \code{ub} and degrees of freedom \code{df}.
}
\details{
The truncation limits can include infinite values. The Monte Carlo (\code{type = "mc"}) uses a sample of size \code{B}, while the
qausi Monte Carlo (\code{type = "qmc"}) uses a pointset of size \code{ceiling(n/12)} and estimates the relative error using 12 independent randomized QMC estimators.

\code{pmvt} computes an estimate and a deterministic upper bound of the distribution function of the multivariate normal distribution.
Infinite values for vectors \eqn{u} and \eqn{l} are accepted. The Monte Carlo method uses sample size \eqn{n}: the larger \eqn{n}, the smaller the relative error of the estimator.
}
\section{Usage}{
 \preformatted{
dtmvt(x, mu, sigma, df, lb, ub, type = c("mc", "qmc"), log = FALSE, B = 1e4)
ptmvt(q, mu, sigma, df, lb, ub, type = c("mc", "qmc"), log = FALSE, B = 1e4)
rtmvt(n, mu, sigma, df, lb, ub)
pmvt(mu, sigma, df, lb = -Inf, ub = Inf, type = c("mc", "qmc"), log = FALSE, B = 1e4)}
}

\examples{
d <- 4; lb <- rep(0, d)
mu <- runif(d)
sigma <- matrix(0.5, d, d) + diag(0.5, d)
samp <- rtmvt(n = 10, mu = mu, sigma = sigma, df = 2, lb = lb)
loglik <- dtmvt(samp, mu = mu, sigma = sigma, df = 2, lb = lb, log = TRUE)
cdf <- ptmvt(samp, mu = mu, sigma = sigma, df = 2, lb = lb, log = TRUE, type = "q")
}
\references{
Z. I. Botev and P. L'Ecuyer (2015), Efficient probability estimation
and simulation of the truncated multivariate Student-t distribution,
Proceedings of the 2015 Winter Simulation Conference, pp. 380-391
}
\author{
Leo Belzile, R port from Matlab code by Z. I. Botev
}
