% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvNqmc.R
\name{mvNqmc}
\alias{mvNqmc}
\title{Truncated multivariate normal cumulative distribution  (quasi-Monte Carlo)}
\usage{
mvNqmc(l, u, Sig, n = 1e+05)
}
\arguments{
\item{l}{lower truncation limit}

\item{u}{upper truncation limit}

\item{Sig}{covariance matrix of \eqn{N(0,\Sigma)}}

\item{n}{number of Monte Carlo simulations}
}
\value{
a list with components
\itemize{
\item{\code{prob}: }{estimated value of probability Pr\eqn{(l<X<u)}}
\item{\code{relErr}: }{estimated relative error of estimator}
\item{\code{upbnd}: }{ theoretical upper bound on true Pr\eqn{(l<X<u)}}
}
}
\description{
Computes an estimate and a deterministic upper bound of the probability Pr\eqn{(l<X<u)},
where \eqn{X} is a zero-mean multivariate normal vector
with covariance matrix \eqn{\Sigma}, that is, \eqn{X} is drawn from \eqn{N(0,\Sigma)}.
Infinite values for vectors \eqn{u} and \eqn{l} are accepted.
The Monte Carlo method uses sample size \eqn{n}: 
the larger \eqn{n}, the smaller the relative error of the estimator.
}
\details{
Suppose you wish to estimate Pr\eqn{(l<AX<u)},
 where \eqn{A} is a full rank matrix
 and \eqn{X} is drawn from \eqn{N(\mu,\Sigma)}, then you simply compute
 Pr\eqn{(l-A\mu<AY<u-A\mu)},
 where \eqn{Y} is drawn from \eqn{N(0, A\Sigma A^\top)}.
}
\note{
This version uses a Quasi Monte Carlo (QMC) pointset
of size \code{ceiling(n/12)} and estimates the relative error
using 12 independent randomized QMC estimators. QMC
is slower than ordinary Monte Carlo,
but is also likely to be more accurate when \eqn{d<50}.
For high dimensions, say \eqn{d>50}, you may obtain the same accuracy using
the (typically faster) \code{\link{mvNcdf}}.
}
\examples{
d <- 15 
l <- 1:d
u <- rep(Inf, d)
Sig <- matrix(rnorm(d^2), d, d)*2 
Sig <- Sig \%*\% t(Sig)
mvNqmc(l, u, Sig, 1e4) # compute the probability
}
\references{
Z. I. Botev (2017), \emph{The Normal Law Under Linear Restrictions:
Simulation and Estimation via Minimax Tilting}, Journal of the Royal
Statistical Society, Series B, \bold{79} (1), pp. 1--24.
}
\seealso{
\code{\link{mvNcdf}}, \code{\link{mvrandn}}
}
\author{
Zdravko I. Botev
}
\keyword{internal}
