% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synLFQ7.R
\docType{data}
\name{synLFQ7}
\alias{synLFQ7}
\title{Synthetic length-frequency data VII with seasonal oscillation}
\format{
A list of class lfq consisting of:
\itemize{
  \item \strong{dates} dates of sampling times (class Date),
  \item \strong{midLengths} midpoints of the length classes,
  \item \strong{catch} matrix with catches/counts per length class (row) and
     sampling date (column).
}
}
\source{
Taylor, M (2016). fishdynr: Fisheries science related population dynamics
models. R package version 0.2. https://github.com/marchtaylor/fishdynr
}
\usage{
data(synLFQ7)
}
\description{
Synthetic length-frequency data as generated by the function
\code{lfqGen} from the \emph{fishdynr} package (Taylor 2016). Can be used by
\code{\link[TropFishR]{ELEFAN}}, \code{\link[TropFishR]{ELEFAN_SA}}, or
 \code{\link[TropFishR]{ELEFAN_GA}}.
The data is generated with the following von Bertalanffy growth parameters:
\itemize{
  \item K = 0.2 +/- 0.1 (CV)
  \item Linf = 123 +/- 0.05 (CV)
  \item C = 0.3
  \item ts = 0
  \item t_anchor between 0.16 and 0.34 (Time when yearly recruitment pulse occurs;
  e.g. 0 = Jan 1, 0.25 = Apr 1, 0.5 = Jul 1, 0.75 = Oct 1;
  repro_wt = c(0, 0, 0.2, 1, 0.6, 0, 0, 0, 0, 0, 0, 0))
}

Further settings include:
\itemize{
  \item Lmat = 30.8 (length at maturity)
  \item L50 = 35 (length at 50\% prob. of capture via trawl net)
  \item wqs = 5 (width between 25\% and 75\% prob. of capture quantiles;
  i.e. wqs = 0 is knife-edge selection)
  \item M = 0.2 (Natural mortality rate)
  \item harvest_rate = 0.3 (Fishing mortality rate)
}
}
\examples{
data(synLFQ7)

# plot of length frequencies
plot(synLFQ7, Fname = "catch")

# plot of restructured length frequencies
synLFQ7 <- lfqRestructure(synLFQ7, MA = 11)
plot(synLFQ7, Fname = "rcounts")



}
\keyword{data}
\keyword{dataset}
\keyword{length-frequency}
